/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.EditorMacro;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.ide.macro.PromptMacro;
import com.intellij.ide.macro.PromptingMacro;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.WorkingDirectoryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class ProgramParametersConfigurator {
    private static final ExtensionPointName<WorkingDirectoryProvider> WORKING_DIRECTORY_PROVIDER_EP_NAME = ExtensionPointName.create((String)"com.intellij.module.workingDirectoryProvider");
    @Deprecated
    public static final String MODULE_WORKING_DIR = "%MODULE_WORKING_DIR%";

    public void configureConfiguration(SimpleProgramParameters parameters, CommonProgramRunConfigurationParameters configuration2) {
        Project project = configuration2.getProject();
        Module module = this.getModule(configuration2);
        parameters.getProgramParametersList().addParametersString(ProgramParametersConfigurator.expandMacros(this.expandPath(configuration2.getProgramParameters(), module, project)));
        parameters.setWorkingDirectory(this.getWorkingDir(configuration2, project, module));
        HashMap<String, String> envs = new HashMap<String, String>(configuration2.getEnvs());
        EnvironmentUtil.inlineParentOccurrences(envs);
        for (Map.Entry entry : envs.entrySet()) {
            entry.setValue(this.expandPath((String)entry.getValue(), module, project));
        }
        parameters.setEnv(envs);
        parameters.setPassParentEnvs(configuration2.isPassParentEnvs());
    }

    public static void addMacroSupport(@NotNull ExpandableTextField expandableTextField) {
        if (Registry.is((String)"allow.macros.for.run.configurations")) {
            expandableTextField.addExtension(ExtendableTextComponent.Extension.create((Icon)AllIcons.General.InlineAdd, (Icon)AllIcons.General.InlineAddHover, (String)"Insert Macros", () -> MacrosDialog.show((JTextComponent)expandableTextField, (Condition<? super Macro>)((Condition)macro -> {
                if (macro instanceof PromptMacro) {
                    return true;
                }
                return !(macro instanceof PromptingMacro) && !(macro instanceof EditorMacro);
            }))));
        }
    }

    public static String expandMacros(@Nullable String path) {
        if (path != null && Registry.is((String)"allow.macros.for.run.configurations")) {
            Collection<Macro> macros = MacroManager.getInstance().getMacros();
            for (Macro macro : macros) {
                String template = "$" + macro.getName() + "$";
                int index = path.indexOf(template);
                while (index != -1 && index < path.length() + template.length()) {
                    String value = StringUtil.notNullize((String)(macro instanceof PromptMacro ? ((PromptMacro)macro).promptUser() : macro.preview()));
                    if (StringUtil.containsWhitespaces((CharSequence)value)) {
                        value = "\"" + value + "\"";
                    }
                    path = path.substring(0, index) + value + path.substring(index + template.length());
                    index += value.length();
                    index = path.indexOf(template, index);
                }
            }
        }
        return path;
    }

    @Nullable
    public String getWorkingDir(CommonProgramRunConfigurationParameters configuration2, Project project, Module module) {
        String workingDirectory = configuration2.getWorkingDirectory();
        String defaultWorkingDir = this.getDefaultWorkingDir(project);
        if (StringUtil.isEmptyOrSpaces((String)workingDirectory) && (workingDirectory = defaultWorkingDir) == null) {
            return null;
        }
        if (!FileUtil.isAbsolutePlatformIndependent((String)(workingDirectory = this.expandPath(workingDirectory, module, project))) && defaultWorkingDir != null) {
            if ("$MODULE_DIR$".equals(workingDirectory)) {
                return defaultWorkingDir;
            }
            if (MODULE_WORKING_DIR.equals(workingDirectory)) {
                workingDirectory = "$MODULE_WORKING_DIR$";
            }
            if ("$MODULE_WORKING_DIR$".equals(workingDirectory)) {
                if (module == null) {
                    return defaultWorkingDir;
                }
                String workingDir = this.getDefaultWorkingDir(module);
                if (workingDir != null) {
                    return workingDir;
                }
            }
            workingDirectory = defaultWorkingDir + "/" + workingDirectory;
        }
        return workingDirectory;
    }

    @Nullable
    protected String getDefaultWorkingDir(@NotNull Project project) {
        return PathUtil.getLocalPath((VirtualFile)project.getBaseDir());
    }

    @Nullable
    protected String getDefaultWorkingDir(@NotNull Module module) {
        for (WorkingDirectoryProvider provider : (WorkingDirectoryProvider[])WORKING_DIRECTORY_PROVIDER_EP_NAME.getExtensions()) {
            @SystemIndependent String path = provider.getWorkingDirectoryPath(module);
            if (path == null) continue;
            return path;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length > 0) {
            return PathUtil.getLocalPath((VirtualFile)roots[0]);
        }
        return null;
    }

    public void checkWorkingDirectoryExist(CommonProgramRunConfigurationParameters configuration2, Project project, Module module) throws RuntimeConfigurationWarning {
        String workingDir = this.getWorkingDir(configuration2, project, module);
        if (workingDir == null) {
            throw new RuntimeConfigurationWarning("Working directory is null for project '" + project.getName() + "' (" + project.getBasePath() + "), module " + (module == null ? "null" : "'" + module.getName() + "' (" + module.getModuleFilePath() + ")"));
        }
        if (!new File(workingDir).exists()) {
            throw new RuntimeConfigurationWarning("Working directory '" + workingDir + "' doesn't exist");
        }
    }

    protected String expandPath(@Nullable String path, Module module, Project project) {
        if (module != null && "$MODULE_DIR$".equals(path) && module.getModuleFilePath().contains("/.idea/") && ExternalProjectSystemRegistry.getInstance().getExternalSource(module) != null) {
            return this.getDefaultWorkingDir(module);
        }
        path = PathMacroManager.getInstance((ComponentManager)project).expandPath(path);
        if (module != null) {
            path = PathMacroManager.getInstance((ComponentManager)module).expandPath(path);
        }
        return path;
    }

    @Nullable
    protected Module getModule(CommonProgramRunConfigurationParameters configuration2) {
        if (configuration2 instanceof ModuleBasedConfiguration) {
            return ((ModuleBasedConfiguration)configuration2).getConfigurationModule().getModule();
        }
        return null;
    }
}

