/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CantRunException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptFileUtil {
    private static final Logger LOG = Logger.getInstance(ScriptFileUtil.class);
    private static final String SCHEME = "mem://";
    private static final Map<String, VirtualFile> ourFilesMap = ContainerUtil.createConcurrentWeakValueMap();
    private static final AtomicLong ourFileCounter = new AtomicLong();

    private ScriptFileUtil() {
    }

    public static boolean isMemoryScriptPath(@Nullable String url) {
        return url != null && url.startsWith(SCHEME);
    }

    public static String getScriptFilePath(@NotNull VirtualFile file2) {
        if (file2.isInLocalFileSystem()) {
            return file2.getPath();
        }
        long id = ourFileCounter.incrementAndGet();
        String url = SCHEME + id + "/" + file2.getName();
        ourFilesMap.put(url, file2);
        return url;
    }

    @Nullable
    public static VirtualFile findScriptFileByPath(@Nullable String path) {
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        if (!path.startsWith(SCHEME)) {
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
        return ourFilesMap.get(path);
    }

    @NotNull
    public static String getLocalFilePath(@NotNull String scriptPath) throws CantRunException {
        if (ScriptFileUtil.isMemoryScriptPath(scriptPath)) {
            File tmpFile = ScriptFileUtil.copyToTempFile(scriptPath);
            return tmpFile.getAbsolutePath();
        }
        return scriptPath;
    }

    @NotNull
    public static File copyToTempFile(@NotNull String path) throws CantRunException {
        File ioFile;
        VirtualFile virtualFile = ScriptFileUtil.findScriptFileByPath(path);
        if (virtualFile == null) {
            throw new CantRunException("File not found: " + path);
        }
        try {
            ioFile = FileUtil.createTempFile((String)virtualFile.getName(), (String)"", (boolean)true);
        }
        catch (IOException e) {
            throw new CantRunException("Cannot create temporary file " + virtualFile.getName(), (Throwable)e);
        }
        try {
            ScriptFileUtil.copyFile(virtualFile, ioFile);
            return ioFile;
        }
        catch (IOException e) {
            throw new CantRunException("Cannot write temp file " + virtualFile.getPath() + " to " + ioFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private static void copyFile(@NotNull VirtualFile srcFile, @NotNull File destFile) throws IOException {
        LOG.info("Copying to " + destFile.getPath());
        CharSequence content = ScriptFileUtil.getContent(srcFile);
        CharBuffer cb = CharBuffer.wrap(content);
        ByteBuffer bb = CharsetToolkit.UTF8_CHARSET.encode(cb);
        byte[] result2 = new byte[bb.remaining()];
        bb.get(result2);
        FileUtil.writeToFile((File)destFile, (byte[])result2, (boolean)false);
    }

    @NotNull
    private static CharSequence getContent(@NotNull VirtualFile file2) {
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        if (document != null) {
            return document.getText();
        }
        return LoadTextUtil.loadText(file2);
    }
}

