/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.Storage;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StoringPropertyContainer
extends AbstractProperty.AbstractPropertyContainer<AbstractProperty<Boolean>> {
    private final Map<AbstractProperty<Boolean>, Boolean> myValues = new HashMap<AbstractProperty<Boolean>, Boolean>();
    private final Storage myStorage;

    public StoringPropertyContainer(String groupName, PropertiesComponent propertiesComponent) {
        this((Storage)new Storage.PropertiesComponentStorage(groupName, propertiesComponent));
    }

    public StoringPropertyContainer(@NotNull Storage storage2) {
        this.myStorage = storage2;
    }

    public void setIfUndefined(@NotNull AbstractProperty<Boolean> property, boolean value) {
        if (this.myStorage.get(property.getName()) == null) {
            this.setValueOf(property, value);
        }
    }

    protected void setValueOf(@NotNull AbstractProperty<Boolean> property, Object value) {
        this.myValues.put(property, (Boolean)value);
        this.onPropertyChanged(property, (Boolean)value);
        this.myStorage.put(property.getName(), value.toString());
    }

    public boolean hasProperty(@NotNull AbstractProperty property) {
        return this.myValues.containsKey(property);
    }

    protected Object getValueOf(@NotNull AbstractProperty<Boolean> property) {
        Boolean value = this.myValues.get(property);
        if (value == null) {
            String stringValue = this.myStorage.get(property.getName());
            value = stringValue != null ? Boolean.valueOf(stringValue) : (Boolean)property.getDefault((AbstractProperty.AbstractPropertyContainer)this);
            this.myValues.put(property, value);
        }
        return value;
    }

    protected <T> void onPropertyChanged(@NotNull AbstractProperty<T> property, T value) {
    }
}

