/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import gnu.trove.THashMap;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLDistribution {
    static final String DEFAULT_WSL_MNT_ROOT = "/mnt/";
    private static final int RESOLVE_SYMLINK_TIMEOUT = 10000;
    private static final String RUN_PARAMETER = "run";
    private static final Logger LOG = Logger.getInstance(WSLDistribution.class);
    private static final Key<ProcessListener> SUDO_LISTENER_KEY = Key.create((String)"WSL sudo listener");
    @NotNull
    private final WslDistributionDescriptor myDescriptor;
    @NotNull
    private final Path myExecutablePath;

    protected WSLDistribution(@NotNull WSLDistribution dist) {
        this(dist.myDescriptor, dist.myExecutablePath);
    }

    WSLDistribution(@NotNull WslDistributionDescriptor descriptor, @NotNull Path executablePath) {
        this.myDescriptor = descriptor;
        this.myExecutablePath = executablePath;
    }

    @NotNull
    public Path getExecutablePath() {
        return this.myExecutablePath;
    }

    @Nullable
    public String readReleaseInfo() {
        try {
            String key = "PRETTY_NAME";
            String releaseInfo = "/etc/os-release";
            ProcessOutput output = this.executeOnWsl(10000, "cat", "/etc/os-release");
            if (!output.checkSuccess(LOG)) {
                return null;
            }
            for (String line : output.getStdoutLines(true)) {
                if (!line.startsWith("PRETTY_NAME") || line.length() < "PRETTY_NAME".length() + 1) continue;
                String prettyName = line.substring("PRETTY_NAME".length() + 1);
                return StringUtil.nullize((String)StringUtil.unquoteString((String)prettyName));
            }
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
        return null;
    }

    @NotNull
    public GeneralCommandLine createWslCommandLine(String ... args) {
        return this.patchCommandLine(new GeneralCommandLine(args), null, null, false);
    }

    public ProcessOutput executeOnWsl(int timeout, @Nullable Consumer<? super ProcessHandler> processHandlerConsumer, String ... args) throws ExecutionException {
        GeneralCommandLine commandLine = this.createWslCommandLine(args);
        CapturingProcessHandler processHandler2 = new CapturingProcessHandler(commandLine);
        if (processHandlerConsumer != null) {
            processHandlerConsumer.consume((Object)processHandler2);
        }
        return WSLUtil.addInputCloseListener(processHandler2).runProcess(timeout);
    }

    public ProcessOutput executeOnWsl(int timeout, String ... args) throws ExecutionException {
        return this.executeOnWsl(timeout, (Consumer<? super ProcessHandler>)null, args);
    }

    public ProcessOutput executeOnWsl(@Nullable Consumer<? super ProcessHandler> processHandlerConsumer, String ... args) throws ExecutionException {
        return this.executeOnWsl(-1, processHandlerConsumer, args);
    }

    public ProcessOutput copyFromWsl(@NotNull String wslPath, @NotNull String windowsPath, @Nullable List<String> additionalOptions, @Nullable Consumer<? super ProcessHandler> handlerConsumer) throws ExecutionException {
        new File(windowsPath).mkdirs();
        ArrayList<String> command = new ArrayList<String>(Arrays.asList("rsync", "-cr"));
        if (additionalOptions != null) {
            command.addAll(additionalOptions);
        }
        command.add(wslPath + "/");
        String targetWslPath = this.getWslPath(windowsPath);
        if (targetWslPath == null) {
            throw new ExecutionException("Unable to copy files to " + windowsPath);
        }
        command.add(targetWslPath + "/");
        return this.executeOnWsl(handlerConsumer, ArrayUtil.toStringArray(command));
    }

    @NotNull
    public <T extends GeneralCommandLine> T patchCommandLine(@NotNull T commandLine, final @Nullable Project project, @Nullable String remoteWorkingDir, boolean askForSudo) {
        THashMap additionalEnvs = new THashMap(commandLine.getEnvironment());
        commandLine.getEnvironment().clear();
        LOG.debug("[" + this.getId() + "] Patching: " + commandLine.getCommandLineString() + "; working dir: " + remoteWorkingDir + "; envs: " + additionalEnvs.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(", ")) + (askForSudo ? "; with sudo" : ": without sudo"));
        StringBuilder commandLineString = new StringBuilder();
        ParametersList parametersList = commandLine.getParametersList();
        List realParamsList = parametersList.getList();
        if (realParamsList.size() == 2 && "bash".equals(commandLine.getExePath()) && "-c".equals(realParamsList.get(0))) {
            commandLineString.append((String)realParamsList.get(1));
        } else {
            commandLineString.append(commandLine.getCommandLineString());
        }
        if (askForSudo) {
            WSLDistribution.prependCommandLineString(commandLineString, "sudo", "-S", "-p", "''");
            SUDO_LISTENER_KEY.set(commandLine, (Object)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    OutputStream input = event.getProcessHandler().getProcessInput();
                    if (input == null) {
                        return;
                    }
                    String password = CredentialPromptDialog.askPassword(project, "Enter Root Password", "Sudo password for " + WSLDistribution.this.getPresentableName() + " root:", new CredentialAttributes("WSL", "root", WSLDistribution.class), true);
                    if (password != null) {
                        try (PrintWriter pw = new PrintWriter(input);){
                            pw.println(password);
                        }
                    }
                    super.startNotified(event);
                }
            });
        }
        if (StringUtil.isNotEmpty((String)remoteWorkingDir)) {
            WSLDistribution.prependCommandLineString(commandLineString, "cd", remoteWorkingDir, "&&");
        }
        additionalEnvs.forEach((key, val) -> {
            if (StringUtil.containsChar((String)val, (char)'*') && !StringUtil.isQuotedString((String)val)) {
                val = "'" + val + "'";
            }
            WSLDistribution.prependCommandLineString(commandLineString, "export", key + "=" + val, "&&");
        });
        commandLine.setExePath(this.getExecutablePath().toString());
        parametersList.clearAll();
        parametersList.add(this.getRunCommandLineParameter());
        parametersList.add(commandLineString.toString());
        LOG.debug("[" + this.getId() + "] Patched as: " + commandLine.getCommandLineString());
        return commandLine;
    }

    @NotNull
    protected String getRunCommandLineParameter() {
        return RUN_PARAMETER;
    }

    @NotNull
    public String resolveSymlink(@NotNull String path, int timeoutInMilliseconds) {
        try {
            ProcessOutput output = this.executeOnWsl(timeoutInMilliseconds, "readlink", "-f", path);
            if (output.getExitCode() == 0) {
                String stdout = output.getStdout().trim();
                if (output.getExitCode() == 0 && StringUtil.isNotEmpty((String)stdout)) {
                    return stdout;
                }
            }
        }
        catch (ExecutionException e) {
            LOG.debug("Error while resolving symlink: " + path, (Throwable)e);
        }
        return path;
    }

    @NotNull
    public String resolveSymlink(@NotNull String path) {
        return this.resolveSymlink(path, 10000);
    }

    @NotNull
    public <T extends ProcessHandler> T patchProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull T processHandler2) {
        ProcessListener listener2 = (ProcessListener)SUDO_LISTENER_KEY.get((UserDataHolder)commandLine);
        if (listener2 != null) {
            processHandler2.addProcessListener(listener2);
            SUDO_LISTENER_KEY.set((UserDataHolder)commandLine, null);
        }
        return processHandler2;
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        try {
            ProcessOutput processOutput = this.executeOnWsl(5000, "env");
            THashMap result2 = new THashMap();
            for (String string : processOutput.getStdoutLines()) {
                int assignIndex = string.indexOf(61);
                if (assignIndex == -1) {
                    result2.put(string, "");
                    continue;
                }
                result2.put(string.substring(0, assignIndex), string.substring(assignIndex + 1));
            }
            return result2;
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            return Collections.emptyMap();
        }
    }

    @Nullable
    public String getWindowsPath(@NotNull String wslPath) {
        return WSLUtil.getWindowsPath(wslPath, this.myDescriptor.getMntRoot());
    }

    @Nullable
    public String getWslPath(@NotNull String windowsPath) {
        if (FileUtil.isWindowsAbsolutePath((String)windowsPath)) {
            return this.myDescriptor.getMntRoot() + WSLDistribution.convertWindowsPath(windowsPath);
        }
        return null;
    }

    @NotNull
    static String convertWindowsPath(@NotNull String windowsAbsolutePath) {
        return Character.toLowerCase(windowsAbsolutePath.charAt(0)) + FileUtil.toSystemIndependentName((String)windowsAbsolutePath.substring(2));
    }

    @NotNull
    public String getId() {
        return this.myDescriptor.getId();
    }

    @NotNull
    public String getMsId() {
        return this.myDescriptor.getMsId();
    }

    @NotNull
    public String getPresentableName() {
        return this.myDescriptor.getPresentableName();
    }

    public String toString() {
        return "WSLDistribution{myDescriptor=" + this.myDescriptor + '}';
    }

    private static void prependCommandLineString(@NotNull StringBuilder commandLineString, String ... commands) {
        commandLineString.insert(0, WSLDistribution.createAdditionalCommand(commands) + " ");
    }

    private static String createAdditionalCommand(String ... commands) {
        return new GeneralCommandLine(commands).getCommandLineString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WSLDistribution that = (WSLDistribution)o;
        return this.myDescriptor.equals(that.myDescriptor);
    }

    public int hashCode() {
        return this.myDescriptor.hashCode();
    }
}

