/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLDistributionWithRoot
extends WSLDistribution {
    private static final Logger LOG = Logger.getInstance(WSLDistributionWithRoot.class);
    private static final AtomicNotNullLazyValue<Map<String, String>> DISTRIBUTION_TO_ROOTFS = AtomicNotNullLazyValue.createValue(() -> {
        HashMap result2 = ContainerUtil.newHashMap();
        String lxss = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss";
        List distributions = WindowsRegistryUtil.readRegistryBranch((String)"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss");
        LOG.debug("Processing Lxss registry: " + distributions.size());
        for (String distribution : distributions) {
            String name = WindowsRegistryUtil.readRegistryValue((String)("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + distribution), (String)"DistributionName");
            String path = WindowsRegistryUtil.readRegistryValue((String)("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + distribution), (String)"BasePath");
            LOG.debug(name + ": " + path);
            if (path == null) continue;
            result2.put(name, path + "\\rootfs");
        }
        return Collections.unmodifiableMap(result2);
    });
    @Nullable
    private final String myWslRootInHost;

    public WSLDistributionWithRoot(@NotNull WSLDistribution wslDistribution) {
        super(wslDistribution);
        String wslRootInHost = (String)((Map)DISTRIBUTION_TO_ROOTFS.getValue()).get(wslDistribution.getMsId());
        if (wslRootInHost == null) {
            LOG.warn("WSL (" + wslDistribution.getPresentableName() + ") rootfs is null");
        } else if (!FileUtil.exists((String)wslRootInHost)) {
            LOG.warn("WSL rootfs doesn't exist: " + wslRootInHost);
            wslRootInHost = null;
        }
        this.myWslRootInHost = wslRootInHost;
    }

    @Override
    @Nullable
    public String getWslPath(@NotNull String windowsPath) {
        String canonicalPath = FileUtil.toCanonicalPath((String)windowsPath);
        if (this.myWslRootInHost != null && FileUtil.isAncestor((String)this.myWslRootInHost, (String)canonicalPath, (boolean)true)) {
            return FileUtil.toSystemIndependentName((String)canonicalPath.substring(this.myWslRootInHost.length()));
        }
        return super.getWslPath(canonicalPath);
    }

    @Override
    @Nullable
    public String getWindowsPath(@NotNull String wslPath) {
        String windowsPath = super.getWindowsPath(wslPath);
        if (windowsPath != null) {
            return windowsPath;
        }
        if (this.myWslRootInHost == null) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)(this.myWslRootInHost + FileUtil.toCanonicalPath((String)wslPath)));
    }
}

