/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLDistributionLegacy;
import com.intellij.execution.wsl.WSLDistributionService;
import com.intellij.execution.wsl.WslDistributionDescriptor;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLUtil {
    private static final ProcessListener INPUT_CLOSE_LISTENER = new ProcessAdapter(){

        public void startNotified(@NotNull ProcessEvent event) {
            OutputStream input = event.getProcessHandler().getProcessInput();
            if (input != null) {
                try {
                    input.flush();
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    };

    public static boolean hasAvailableDistributions() {
        return !WSLUtil.getAvailableDistributions().isEmpty();
    }

    @NotNull
    public static List<WSLDistribution> getAvailableDistributions() {
        if (!WSLUtil.isSystemCompatible()) {
            return Collections.emptyList();
        }
        Path executableRoot = WSLUtil.getExecutableRootPath();
        if (executableRoot == null) {
            return Collections.emptyList();
        }
        Collection<WslDistributionDescriptor> descriptors = WSLDistributionService.getInstance().getDescriptors();
        ArrayList<WSLDistribution> result2 = new ArrayList<WSLDistribution>(descriptors.size() + 1);
        for (WslDistributionDescriptor descriptor : descriptors) {
            Path executablePath = Paths.get(descriptor.getExecutablePath(), new String[0]);
            if (!executablePath.isAbsolute()) {
                executablePath = executableRoot.resolve(executablePath);
            }
            if (!Files.exists(executablePath, LinkOption.NOFOLLOW_LINKS)) continue;
            result2.add(new WSLDistribution(descriptor, executablePath));
        }
        if (Experiments.isFeatureEnabled((String)"wsl.legacy.distribution")) {
            ContainerUtil.addIfNotNull(result2, (Object)WSLDistributionLegacy.getInstance());
        }
        return result2;
    }

    @Nullable
    private static Path getExecutableRootPath() {
        String localAppDataPath = System.getenv().get("LOCALAPPDATA");
        return StringUtil.isEmpty((String)localAppDataPath) ? null : Paths.get(localAppDataPath, "Microsoft\\WindowsApps");
    }

    @Nullable
    public static WSLDistribution getDistributionById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        for (WSLDistribution distribution : WSLUtil.getAvailableDistributions()) {
            if (!id.equals(distribution.getId())) continue;
            return distribution;
        }
        return null;
    }

    @ApiStatus.ScheduledForRemoval(inVersion="2019.2")
    @NotNull
    public static <T extends ProcessHandler> T addInputCloseListener(@NotNull T processHandler2) {
        if (Experiments.isFeatureEnabled((String)"wsl.close.process.input")) {
            processHandler2.removeProcessListener(INPUT_CLOSE_LISTENER);
            processHandler2.addProcessListener(INPUT_CLOSE_LISTENER);
        }
        return processHandler2;
    }

    public static boolean isSystemCompatible() {
        return SystemInfo.isWin10OrNewer;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.2")
    @Nullable
    public static String getWindowsPath(@NotNull String wslPath) {
        return WSLUtil.getWindowsPath(wslPath, "/mnt/");
    }

    @Nullable
    public static String getWindowsPath(@NotNull String wslPath, @NotNull String mntRoot) {
        if (!wslPath.startsWith(mntRoot)) {
            return null;
        }
        int driveLetterIndex = mntRoot.length();
        if (driveLetterIndex >= wslPath.length() || !Character.isLetter(wslPath.charAt(driveLetterIndex))) {
            return null;
        }
        int slashIndex = driveLetterIndex + 1;
        if (slashIndex < wslPath.length() && wslPath.charAt(slashIndex) != '/') {
            return null;
        }
        return FileUtil.toSystemDependentName((String)(Character.toUpperCase(wslPath.charAt(driveLetterIndex)) + ":" + wslPath.substring(slashIndex)));
    }
}

