/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.SubstrateRef;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubBasedPsiElementBase<T extends StubElement>
extends ASTDelegatePsiElement {
    public static final Key<String> CREATION_TRACE = Key.create((String)"CREATION_TRACE");
    public static final boolean ourTraceStubAstBinding = "true".equals(System.getProperty("trace.stub.ast.binding", "false"));
    private volatile SubstrateRef mySubstrateRef;
    private final IElementType myElementType;

    public StubBasedPsiElementBase(@NotNull T stub, @NotNull IStubElementType nodeType) {
        this.mySubstrateRef = new SubstrateRef.StubRef((StubElement)stub);
        this.myElementType = nodeType;
    }

    public StubBasedPsiElementBase(@NotNull ASTNode node) {
        this.mySubstrateRef = SubstrateRef.createAstStrongRef(node);
        this.myElementType = node.getElementType();
    }

    public StubBasedPsiElementBase(T stub, IElementType nodeType, ASTNode node) {
        if (stub != null) {
            if (nodeType == null) {
                throw new IllegalArgumentException("null cannot be passed to 'nodeType' when 'stub' is non-null");
            }
            if (node != null) {
                throw new IllegalArgumentException("null must be passed to 'node' parameter when 'stub' is non-null");
            }
            this.mySubstrateRef = new SubstrateRef.StubRef((StubElement)stub);
            this.myElementType = nodeType;
        } else {
            if (node == null) {
                throw new IllegalArgumentException("'stub' and 'node' parameters cannot be null both");
            }
            if (nodeType != null) {
                throw new IllegalArgumentException("null must be passed to 'nodeType' parameter when 'node' is non-null");
            }
            this.mySubstrateRef = SubstrateRef.createAstStrongRef(node);
            this.myElementType = node.getElementType();
        }
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        if (this.mySubstrateRef instanceof SubstrateRef.StubRef) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            PsiFileImpl file2 = (PsiFileImpl)this.getContainingFile();
            if (!file2.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)file2);
            }
            FileElement treeElement = file2.getTreeElement();
            if (treeElement != null && this.mySubstrateRef instanceof SubstrateRef.StubRef) {
                return this.notBoundInExistingAst(file2, treeElement);
            }
            treeElement = file2.calcTreeElement();
            if (this.mySubstrateRef instanceof SubstrateRef.StubRef) {
                return this.failedToBindStubToAst(file2, treeElement);
            }
        }
        return this.mySubstrateRef.getNode();
    }

    private ASTNode failedToBindStubToAst(@NotNull PsiFileImpl file2, @NotNull FileElement fileElement) {
        VirtualFile vFile = file2.getVirtualFile();
        StubTree stubTree = file2.getStubTree();
        String stubString = stubTree != null ? ((PsiFileStubImpl)stubTree.getRoot()).printTree() : null;
        String astString = (String)RecursionManager.doPreventingRecursion((Object)"failedToBindStubToAst", (boolean)true, () -> DebugUtil.treeToString(fileElement, true));
        String message = "Failed to bind stub to AST for element " + ((Object)((Object)this)).getClass() + " in " + (vFile == null ? "<unknown file>" : vFile.getPath()) + "\nFile:\n" + file2 + "@" + System.identityHashCode(file2);
        String creationTraces = ourTraceStubAstBinding ? this.dumpCreationTraces(fileElement) : null;
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (stubString != null) {
            attachments.add(new Attachment("stubTree.txt", stubString));
        }
        if (astString != null) {
            attachments.add(new Attachment("ast.txt", astString));
        }
        if (creationTraces != null) {
            attachments.add(new Attachment("creationTraces.txt", creationTraces));
        }
        throw new RuntimeExceptionWithAttachments(message, attachments.toArray(Attachment.EMPTY_ARRAY));
    }

    @NotNull
    private String dumpCreationTraces(@NotNull FileElement fileElement) {
        final StringBuilder traces = new StringBuilder("\nNow " + Thread.currentThread() + "\n");
        traces.append("My creation trace:\n").append((String)this.getUserData(CREATION_TRACE));
        traces.append("AST creation traces:\n");
        fileElement.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            public void visitComposite(CompositeElement composite) {
                PsiElement psi = composite.getPsi();
                if (psi != null) {
                    traces.append(psi).append("@").append(System.identityHashCode(psi)).append("\n");
                    String trace = (String)psi.getUserData(CREATION_TRACE);
                    if (trace != null) {
                        traces.append(trace).append("\n");
                    }
                }
                super.visitComposite(composite);
            }
        });
        return traces.toString();
    }

    private ASTNode notBoundInExistingAst(@NotNull PsiFileImpl file2, @NotNull FileElement treeElement) {
        String message = "file=" + file2 + "; tree=" + treeElement;
        for (StubBasedPsiElementBase each = this; each != null; each = each.getParentByStub()) {
            message = message + "\n each of class " + ((Object)((Object)each)).getClass() + "; valid=" + each.isValid();
            if (each instanceof StubBasedPsiElementBase) {
                message = message + "; ref=" + each.mySubstrateRef;
                continue;
            }
            if (!(each instanceof PsiFile)) break;
            message = message + "; same file=" + (each == file2) + "; current tree= " + file2.getTreeElement() + "; stubTree=" + file2.getStubTree() + "; physical=" + file2.isPhysical();
            break;
        }
        for (Object eachStub = this.getStub(); eachStub != null; eachStub = eachStub.getParentStub()) {
            message = message + "\n each stub " + (eachStub instanceof PsiFileStubImpl ? ((PsiFileStubImpl)((Object)eachStub)).getDiagnostics() : eachStub);
        }
        if (ourTraceStubAstBinding) {
            message = message + this.dumpCreationTraces(treeElement);
        }
        throw new AssertionError((Object)message);
    }

    public final void setNode(@NotNull ASTNode node) {
        this.setSubstrateRef(SubstrateRef.createAstStrongRef(node));
    }

    public final void setSubstrateRef(@NotNull SubstrateRef substrateRef) {
        this.mySubstrateRef = substrateRef;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return this.myElementType.getLanguage();
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        try {
            return this.mySubstrateRef.getContainingFile();
        }
        catch (PsiInvalidElementAccessException e) {
            if (PsiInvalidElementAccessException.getInvalidationTrace((UserDataHolder)this) != null) {
                throw new PsiInvalidElementAccessException((PsiElement)this, (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public boolean isWritable() {
        return this.getContainingFile().isWritable();
    }

    @Override
    public boolean isValid() {
        ProgressManager.checkCanceled();
        return this.mySubstrateRef.isValid();
    }

    @Override
    public PsiManagerEx getManager() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            return PsiManagerEx.getInstanceEx(project);
        }
        return (PsiManagerEx)this.getContainingFile().getManager();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            return project;
        }
        return this.getContainingFile().getProject();
    }

    @Override
    public boolean isPhysical() {
        return this.getContainingFile().isPhysical();
    }

    @Override
    public PsiElement getContext() {
        T stub = this.getStub();
        if (stub != null && !(stub instanceof PsiFileStub)) {
            return stub.getParentStub().getPsi();
        }
        return super.getContext();
    }

    protected final PsiElement getParentByStub() {
        T stub = this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        return SharedImplUtil.getParent(this.getNode());
    }

    @Deprecated
    protected final PsiElement getParentByTree() {
        return SharedImplUtil.getParent(this.getNode());
    }

    public PsiElement getParent() {
        T stub = this.getGreenStub();
        if (stub != null && !((ObjectStubBase)stub).isDangling()) {
            return stub.getParentStub().getPsi();
        }
        return SourceTreeToPsiMap.treeElementToPsi(this.getNode().getTreeParent());
    }

    @NotNull
    public IStubElementType getElementType() {
        if (!(this.myElementType instanceof IStubElementType)) {
            throw new ClassCastException("Not a stub type: " + this.myElementType + " in " + ((Object)((Object)this)).getClass());
        }
        return (IStubElementType)this.myElementType;
    }

    @Nullable
    public T getStub() {
        ProgressIndicatorProvider.checkCanceled();
        return (T)((StubElement)this.mySubstrateRef.getStub());
    }

    @Nullable
    public final T getGreenStub() {
        ProgressIndicatorProvider.checkCanceled();
        return (T)((StubElement)this.mySubstrateRef.getGreenStub());
    }

    @Nullable
    public <Psi extends PsiElement> Psi getStubOrPsiChild(@NotNull IStubElementType<? extends StubElement, Psi> elementType) {
        T stub = this.getGreenStub();
        if (stub != null) {
            StubElement element = stub.findChildStubByType(elementType);
            if (element != null) {
                return (Psi)element.getPsi();
            }
        } else {
            ASTNode childNode = this.getNode().findChildByType(elementType);
            if (childNode != null) {
                return (Psi)childNode.getPsi();
            }
        }
        return null;
    }

    @NotNull
    public <S extends StubElement, Psi extends PsiElement> Psi getRequiredStubOrPsiChild(@NotNull IStubElementType<S, Psi> elementType) {
        Psi result2 = this.getStubOrPsiChild(elementType);
        if (result2 == null) {
            throw new AssertionError((Object)("Missing required child of type " + elementType + "; tree: " + DebugUtil.psiToString((PsiElement)this, false)));
        }
        return result2;
    }

    @NotNull
    public <S extends StubElement, Psi extends PsiElement> Psi[] getStubOrPsiChildren(@NotNull IStubElementType<S, ? extends Psi> elementType, @NotNull Psi[] array) {
        T stub = this.getGreenStub();
        if (stub != null) {
            return stub.getChildrenByType(elementType, array);
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])Array.newInstance(array.getClass().getComponentType(), nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        return psiElements;
    }

    @NotNull
    public <S extends StubElement, Psi extends PsiElement> Psi[] getStubOrPsiChildren(@NotNull IStubElementType<S, ? extends Psi> elementType, @NotNull ArrayFactory<Psi> f) {
        T stub = this.getGreenStub();
        if (stub != null) {
            return stub.getChildrenByType(elementType, f);
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        return psiElements;
    }

    @NotNull
    public <Psi extends PsiElement> Psi[] getStubOrPsiChildren(@NotNull TokenSet filter, @NotNull Psi[] array) {
        T stub = this.getGreenStub();
        if (stub != null) {
            return stub.getChildrenByType(filter, array);
        }
        ASTNode[] nodes = this.getNode().getChildren(filter);
        PsiElement[] psiElements = (PsiElement[])Array.newInstance(array.getClass().getComponentType(), nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        return psiElements;
    }

    @NotNull
    public <Psi extends PsiElement> Psi[] getStubOrPsiChildren(@NotNull TokenSet filter, @NotNull ArrayFactory<Psi> f) {
        T stub = this.getGreenStub();
        if (stub != null) {
            return stub.getChildrenByType(filter, f);
        }
        ASTNode[] nodes = this.getNode().getChildren(filter);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        return psiElements;
    }

    @Nullable
    protected <E extends PsiElement> E getStubOrPsiParentOfType(@NotNull Class<E> parentClass) {
        T stub = this.getStub();
        if (stub != null) {
            return (E)stub.getParentStubOfType(parentClass);
        }
        return (E)PsiTreeUtil.getParentOfType((PsiElement)this, parentClass);
    }

    protected Object clone() {
        StubBasedPsiElementBase copy = (StubBasedPsiElementBase)((Object)super.clone());
        copy.setSubstrateRef(SubstrateRef.createAstStrongRef(this.getNode()));
        return copy;
    }
}

