/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class CheckRequiredPluginsActivity
implements StartupActivity,
DumbAware {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Required Plugins", NotificationDisplayType.BALLOON, true);

    public void runActivity(@NotNull Project project) {
        ExternalDependenciesManager.getInstance(project);
    }

    public static void runCheck(final @NotNull Project project) {
        List<DependencyOnPlugin> dependencies = ExternalDependenciesManager.getInstance(project).getDependencies(DependencyOnPlugin.class);
        if (dependencies.isEmpty()) {
            return;
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        final ArrayList<IdeaPluginDescriptor> disabled = new ArrayList<IdeaPluginDescriptor>();
        final ArrayList<PluginId> notInstalled = new ArrayList<PluginId>();
        for (DependencyOnPlugin dependency : dependencies) {
            PluginId pluginId = PluginId.getId((String)dependency.getPluginId());
            IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
            if (plugin == null) {
                errorMessages.add("Plugin '" + dependency.getPluginId() + "' required for '" + project.getName() + "' project isn't installed.");
                notInstalled.add(pluginId);
                continue;
            }
            if (!plugin.isEnabled()) {
                errorMessages.add("Plugin '" + plugin.getName() + "' required for '" + project.getName() + "' project is disabled.");
                disabled.add(plugin);
                continue;
            }
            String minVersion = dependency.getMinVersion();
            String maxVersion = dependency.getMaxVersion();
            String pluginVersion = plugin.getVersion();
            BuildNumber currentIdeVersion = ApplicationInfo.getInstance().getBuild();
            if (plugin.isBundled() && !plugin.allowBundledUpdate() && currentIdeVersion.asStringWithoutProductCode().equals(pluginVersion)) {
                String pluginFromString;
                String string = pluginFromString = "com.intellij".equals(plugin.getPluginId().getIdString()) ? "" : "plugin '" + plugin.getName() + "' from ";
                if (minVersion != null && currentIdeVersion.compareTo(BuildNumber.fromString((String)minVersion)) < 0) {
                    errorMessages.add("Project '" + project.getName() + "' requires " + pluginFromString + "'" + minVersion + "' or newer build of the IDE, but the current build is '" + pluginVersion + "'.");
                }
                if (maxVersion == null || currentIdeVersion.compareTo(BuildNumber.fromString((String)maxVersion)) <= 0) continue;
                errorMessages.add("Project '" + project.getName() + "' requires " + pluginFromString + "'" + maxVersion + "' or older build of the IDE, but the current build is '" + pluginVersion + "'.");
                continue;
            }
            if (minVersion != null && VersionComparatorUtil.compare((String)pluginVersion, (String)minVersion) < 0) {
                errorMessages.add("Project '" + project.getName() + "' requires plugin  '" + plugin.getName() + "' version '" + minVersion + "' or higher, but '" + pluginVersion + "' is installed.");
            }
            if (maxVersion == null || VersionComparatorUtil.compare((String)pluginVersion, (String)maxVersion) <= 0) continue;
            errorMessages.add("Project '" + project.getName() + "' requires plugin  '" + plugin.getName() + "' version '" + maxVersion + "' or lower, but '" + pluginVersion + "' is installed.");
        }
        if (!errorMessages.isEmpty()) {
            if (!disabled.isEmpty() && notInstalled.isEmpty()) {
                String plugins2 = disabled.size() == 1 ? ((IdeaPluginDescriptor)disabled.get(0)).getName() : "required plugins";
                errorMessages.add("<a href=\"enable\">Enable " + plugins2 + "</a>");
            } else if (!disabled.isEmpty() || !notInstalled.isEmpty()) {
                errorMessages.add("<a href=\"install\">Install required plugins</a>");
            }
            NOTIFICATION_GROUP.createNotification("Required plugins weren't loaded", StringUtil.join(errorMessages, (String)"<br>"), NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if ("enable".equals(event.getDescription())) {
                            notification.expire();
                            for (IdeaPluginDescriptor descriptor : disabled) {
                                PluginManagerCore.enablePlugin(descriptor.getPluginId().getIdString());
                            }
                            PluginManagerMain.notifyPluginsUpdated(project);
                        } else {
                            HashSet<String> pluginIds = new HashSet<String>();
                            for (IdeaPluginDescriptor descriptor : disabled) {
                                pluginIds.add(descriptor.getPluginId().getIdString());
                            }
                            for (PluginId pluginId : notInstalled) {
                                pluginIds.add(pluginId.getIdString());
                            }
                            PluginsAdvertiser.installAndEnablePlugins(pluginIds, () -> notification.expire());
                        }
                    }
                }
            }).notify(project);
        }
    }
}

