/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetFinderImpl
extends FacetFinder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.FacetFinderImpl");
    private final Map<FacetTypeId, AllFacetsOfTypeModificationTracker> myAllFacetTrackers = new HashMap<FacetTypeId, AllFacetsOfTypeModificationTracker>();
    private final Map<FacetTypeId, CachedValue<Map<VirtualFile, List<Facet>>>> myCachedMaps = new HashMap<FacetTypeId, CachedValue<Map<VirtualFile, List<Facet>>>>();
    private final Project myProject;
    private final CachedValuesManager myCachedValuesManager;
    private final ModuleManager myModuleManager;

    public FacetFinderImpl(Project project) {
        this.myProject = project;
        this.myCachedValuesManager = CachedValuesManager.getManager((Project)project);
        this.myModuleManager = ModuleManager.getInstance((Project)this.myProject);
    }

    public <F extends Facet> ModificationTracker getAllFacetsOfTypeModificationTracker(FacetTypeId<F> type) {
        AllFacetsOfTypeModificationTracker<F> tracker = this.myAllFacetTrackers.get(type);
        if (tracker == null) {
            tracker = new AllFacetsOfTypeModificationTracker<F>(this.myProject, type);
            Disposer.register((Disposable)this.myProject, tracker);
            this.myAllFacetTrackers.put(type, tracker);
        }
        return tracker;
    }

    private <F extends Facet> Map<VirtualFile, List<Facet>> getRootToFacetsMap(FacetTypeId<F> type) {
        Map value;
        CachedValue cachedValue = this.myCachedMaps.get(type);
        if (cachedValue == null) {
            cachedValue = this.myCachedValuesManager.createCachedValue(() -> {
                Map<VirtualFile, List<Facet>> map2 = this.computeRootToFacetsMap(type);
                return CachedValueProvider.Result.create(map2, (Object[])new Object[]{this.getAllFacetsOfTypeModificationTracker(type)});
            }, false);
            this.myCachedMaps.put(type, (CachedValue<Map<VirtualFile, List<Facet>>>)cachedValue);
        }
        LOG.assertTrue((value = (Map)cachedValue.getValue()) != null);
        return value;
    }

    @NotNull
    private <F extends Facet> Map<VirtualFile, List<Facet>> computeRootToFacetsMap(FacetTypeId<F> type) {
        Module[] modules = this.myModuleManager.getModules();
        HashMap<VirtualFile, List<Facet>> map2 = new HashMap<VirtualFile, List<Facet>>();
        for (Module module : modules) {
            Collection facets = FacetManager.getInstance((Module)module).getFacetsByType(type);
            for (Facet facet : facets) {
                for (VirtualFile root : ((FacetRootsProvider)facet).getFacetRoots()) {
                    SmartList list2 = map2.get(root);
                    if (list2 == null) {
                        list2 = new SmartList();
                        map2.put(root, (List<Facet>)list2);
                    }
                    list2.add((Facet)facet);
                }
            }
        }
        return map2;
    }

    @Nullable
    public <F extends Facet> F findFacet(VirtualFile file2, FacetTypeId<F> type) {
        Collection list2 = this.findFacets(file2, (FacetTypeId)type);
        return (F)(list2.size() > 0 ? (Facet)list2.get(0) : null);
    }

    @NotNull
    public <F extends Facet> List<F> findFacets(VirtualFile file2, FacetTypeId<F> type) {
        Map<VirtualFile, List<Facet>> map2 = this.getRootToFacetsMap(type);
        if (!map2.isEmpty()) {
            while (file2 != null) {
                List<Facet> list2 = map2.get(file2);
                if (list2 != null) {
                    return list2;
                }
                file2 = file2.getParent();
            }
        }
        return Collections.emptyList();
    }

    private static class AllFacetsOfTypeModificationTracker<F extends Facet>
    extends SimpleModificationTracker
    implements Disposable,
    ProjectWideFacetListener<F> {
        AllFacetsOfTypeModificationTracker(Project project, FacetTypeId<F> type) {
            ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener(type, (ProjectWideFacetListener)this, (Disposable)this);
        }

        public void facetAdded(@NotNull F facet) {
            this.incModificationCount();
        }

        public void facetRemoved(@NotNull F facet) {
            this.incModificationCount();
        }

        public void facetConfigurationChanged(@NotNull F facet) {
            this.incModificationCount();
        }

        public void firstFacetAdded() {
        }

        public void beforeFacetRemoved(@NotNull F facet) {
        }

        public void allFacetsRemoved() {
        }

        public void dispose() {
        }
    }
}

