/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Arrays;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetUtil {
    public static <F extends Facet> F addFacet(Module module, FacetType<F, ?> type) {
        ModifiableFacetModel model = FacetManager.getInstance((Module)module).createModifiableModel();
        Object facet = FacetUtil.createFacet(module, type);
        ApplicationManager.getApplication().runWriteAction(() -> {
            model.addFacet(facet);
            model.commit();
        });
        return facet;
    }

    private static <F extends Facet, C extends FacetConfiguration> F createFacet(Module module, FacetType<F, C> type) {
        return (F)FacetManager.getInstance((Module)module).createFacet(type, type.getPresentableName(), type.createDefaultConfiguration(), null);
    }

    public static void deleteFacet(Facet facet) {
        WriteAction.runAndWait(() -> {
            if (!FacetUtil.isRegistered(facet)) {
                return;
            }
            ModifiableFacetModel model = FacetManager.getInstance((Module)facet.getModule()).createModifiableModel();
            model.removeFacet(facet);
            model.commit();
        });
    }

    public static boolean isRegistered(Facet facet) {
        return Arrays.asList(FacetManager.getInstance((Module)facet.getModule()).getAllFacets()).contains(facet);
    }

    public static void loadFacetConfiguration(@NotNull FacetConfiguration configuration2, @Nullable Element config2) throws InvalidDataException {
        if (config2 != null) {
            if (configuration2 instanceof PersistentStateComponent) {
                ComponentSerializationUtil.loadComponentState((PersistentStateComponent)((PersistentStateComponent)configuration2), (Element)config2);
            } else {
                configuration2.readExternal(config2);
            }
        }
    }

    public static Element saveFacetConfiguration(FacetConfiguration configuration2) throws WriteExternalException {
        if (configuration2 instanceof PersistentStateComponent) {
            Object state = ((PersistentStateComponent)configuration2).getState();
            if (state instanceof Element) {
                return (Element)state;
            }
            return XmlSerializer.serialize((Object)state, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        }
        Element config2 = new Element("configuration");
        configuration2.writeExternal(config2);
        return config2;
    }
}

