/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.ProjectFacetManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectFacetManager")
public class ProjectFacetManagerImpl
extends ProjectFacetManagerEx
implements PersistentStateComponent<ProjectFacetManagerState> {
    @NonNls
    public static final String COMPONENT_NAME = "ProjectFacetManager";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.ProjectFacetManagerImpl");
    private ProjectFacetManagerState myState = new ProjectFacetManagerState();
    private final Project myProject;
    private volatile MultiMap<FacetTypeId<?>, Module> myIndex;

    public ProjectFacetManagerImpl(Project project) {
        this.myProject = project;
        ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetAdded(@NotNull Facet facet) {
                ProjectFacetManagerImpl.this.myIndex = null;
            }

            public void facetRemoved(@NotNull Facet facet) {
                ProjectFacetManagerImpl.this.myIndex = null;
            }
        }, (Disposable)project);
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                ProjectFacetManagerImpl.this.myIndex = null;
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                ProjectFacetManagerImpl.this.myIndex = null;
            }
        });
    }

    public ProjectFacetManagerState getState() {
        return this.myState;
    }

    public void loadState(@NotNull ProjectFacetManagerState state) {
        this.myState = state;
    }

    @NotNull
    private MultiMap<FacetTypeId<?>, Module> getIndex() {
        MultiMap index = this.myIndex;
        if (index == null) {
            index = MultiMap.createLinked();
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
                    index.putValue((Object)facet.getTypeId(), (Object)module);
                }
            }
            this.myIndex = index;
        }
        return index;
    }

    @NotNull
    public <F extends Facet> List<F> getFacets(@NotNull FacetTypeId<F> typeId) {
        return ContainerUtil.concat((Iterable)this.getIndex().get(typeId), module -> FacetManager.getInstance((Module)module).getFacetsByType(typeId));
    }

    @NotNull
    public List<Module> getModulesWithFacet(@NotNull FacetTypeId<?> typeId) {
        return Collections.unmodifiableList((List)this.getIndex().get(typeId));
    }

    public boolean hasFacets(@NotNull FacetTypeId<?> typeId) {
        return this.getIndex().containsKey(typeId);
    }

    public <F extends Facet> List<F> getFacets(@NotNull FacetTypeId<F> typeId, Module[] modules) {
        ArrayList result2 = new ArrayList();
        for (Module module : modules) {
            result2.addAll(FacetManager.getInstance((Module)module).getFacetsByType(typeId));
        }
        return result2;
    }

    public <C extends FacetConfiguration> C createDefaultConfiguration(@NotNull FacetType<?, C> facetType) {
        FacetConfiguration configuration2 = facetType.createDefaultConfiguration();
        DefaultFacetConfigurationState state = this.myState.getDefaultConfigurations().get(facetType.getStringId());
        if (state != null) {
            Element defaultConfiguration = state.getDefaultConfiguration();
            try {
                FacetUtil.loadFacetConfiguration(configuration2, defaultConfiguration);
            }
            catch (InvalidDataException e) {
                LOG.info((Throwable)e);
            }
        }
        return (C)configuration2;
    }

    public <C extends FacetConfiguration> void setDefaultConfiguration(@NotNull FacetType<?, C> facetType, @NotNull C configuration2) {
        Map<String, DefaultFacetConfigurationState> defaultConfigurations = this.myState.getDefaultConfigurations();
        DefaultFacetConfigurationState state = defaultConfigurations.get(facetType.getStringId());
        if (state == null) {
            state = new DefaultFacetConfigurationState();
            defaultConfigurations.put(facetType.getStringId(), state);
        }
        try {
            Element element = FacetUtil.saveFacetConfiguration(configuration2);
            state.setDefaultConfiguration(element);
        }
        catch (WriteExternalException e) {
            LOG.info((Throwable)e);
        }
    }

    public static class ProjectFacetManagerState {
        private Map<String, DefaultFacetConfigurationState> myDefaultConfigurations = new HashMap<String, DefaultFacetConfigurationState>();

        @Tag(value="default-configurations")
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, keyAttributeName="facet-type")
        public Map<String, DefaultFacetConfigurationState> getDefaultConfigurations() {
            return this.myDefaultConfigurations;
        }

        public void setDefaultConfigurations(Map<String, DefaultFacetConfigurationState> defaultConfigurations) {
            this.myDefaultConfigurations = defaultConfigurations;
        }
    }

    @Tag(value="default-facet-configuration")
    public static class DefaultFacetConfigurationState {
        private Element myDefaultConfiguration;

        @Tag(value="configuration")
        public Element getDefaultConfiguration() {
            return this.myDefaultConfiguration;
        }

        public void setDefaultConfiguration(Element defaultConfiguration) {
            this.myDefaultConfiguration = defaultConfiguration;
        }
    }
}

