/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FacetDependentToolWindowManager
implements ProjectComponent {
    private final Project myProject;
    private final ProjectWideFacetListenersRegistry myFacetListenersRegistry;
    private final ProjectFacetManager myFacetManager;
    private final ToolWindowManagerEx myToolWindowManager;

    protected FacetDependentToolWindowManager(Project project, ProjectWideFacetListenersRegistry facetListenersRegistry, ProjectFacetManager facetManager, ToolWindowManagerEx toolWindowManager) {
        this.myProject = project;
        this.myFacetListenersRegistry = facetListenersRegistry;
        this.myFacetManager = facetManager;
        this.myToolWindowManager = toolWindowManager;
    }

    public void projectOpened() {
        this.myFacetListenersRegistry.registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetAdded(@NotNull Facet facet) {
                for (FacetDependentToolWindow extension : FacetDependentToolWindowManager.getDependentExtensions(facet)) {
                    FacetDependentToolWindowManager.this.ensureToolWindowExists(extension);
                }
            }

            public void facetRemoved(@NotNull Facet facet) {
                if (!FacetDependentToolWindowManager.this.myFacetManager.hasFacets(facet.getTypeId())) {
                    for (FacetDependentToolWindow extension : FacetDependentToolWindowManager.getDependentExtensions(facet)) {
                        ToolWindow toolWindow = FacetDependentToolWindowManager.this.myToolWindowManager.getToolWindow(extension.id);
                        if (toolWindow == null) continue;
                        List facetTypes = extension.getFacetTypes();
                        for (FacetType facetType : facetTypes) {
                            if (!FacetDependentToolWindowManager.this.myFacetManager.hasFacets(facetType.getId())) continue;
                            return;
                        }
                        FacetDependentToolWindowManager.this.myToolWindowManager.unregisterToolWindow(extension.id);
                    }
                }
            }
        }, (Disposable)this.myProject);
        block0: for (FacetDependentToolWindow extension : FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList()) {
            for (FacetType type : extension.getFacetTypes()) {
                if (!this.myFacetManager.hasFacets(type.getId())) continue;
                this.ensureToolWindowExists(extension);
                continue block0;
            }
        }
    }

    private void ensureToolWindowExists(FacetDependentToolWindow extension) {
        Condition condition;
        ToolWindow toolWindow = this.myToolWindowManager.getToolWindow(extension.id);
        if (toolWindow == null && ((condition = extension.getCondition()) == null || condition.value((Object)this.myProject))) {
            this.myToolWindowManager.initToolWindow((ToolWindowEP)extension);
        }
    }

    private static List<FacetDependentToolWindow> getDependentExtensions(Facet facet) {
        return ContainerUtil.filter((Collection)FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList(), toolWindowEP -> {
            for (String id : toolWindowEP.getFacetIds()) {
                if (!facet.getType().getStringId().equals(id)) continue;
                return true;
            }
            return false;
        });
    }
}

