/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.featureStatistics.ApplicabilityFilter;
import com.intellij.featureStatistics.CompletionStatistics;
import com.intellij.featureStatistics.CumulativeStatistics;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="FeatureUsageStatistics", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED)})
public class FeatureUsageTrackerImpl
extends FeatureUsageTracker
implements PersistentStateComponent<Element> {
    private static final int HOUR = 3600000;
    private static final long DAY = 86400000L;
    private long FIRST_RUN_TIME = 0L;
    private CompletionStatistics myCompletionStats = new CompletionStatistics();
    private CumulativeStatistics myFixesStats = new CumulativeStatistics();
    boolean HAVE_BEEN_SHOWN = false;
    private final ProductivityFeaturesRegistry myRegistry;
    @NonNls
    private static final String FEATURE_TAG = "feature";
    @NonNls
    private static final String ATT_SHOW_IN_OTHER = "show-in-other";
    @NonNls
    private static final String ATT_SHOW_IN_COMPILATION = "show-in-compilation";
    @NonNls
    private static final String ATT_ID = "id";
    @NonNls
    private static final String ATT_FIRST_RUN = "first-run";
    @NonNls
    private static final String COMPLETION_STATS_TAG = "completionStatsTag";
    @NonNls
    private static final String FIXES_STATS_TAG = "fixesStatsTag";
    @NonNls
    private static final String ATT_HAVE_BEEN_SHOWN = "have-been-shown";

    public FeatureUsageTrackerImpl(ProductivityFeaturesRegistry productivityFeaturesRegistry) {
        this.myRegistry = productivityFeaturesRegistry;
    }

    public boolean isToBeShown(String featureId, Project project) {
        return this.isToBeShown(featureId, project, 86400000L);
    }

    private boolean isToBeShown(String featureId, Project project, long timeUnit) {
        ApplicabilityFilter[] filters;
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        FeatureDescriptor descriptor = registry.getFeatureDescriptor(featureId);
        if (descriptor == null || !descriptor.isUnused()) {
            return false;
        }
        String[] dependencyFeatures = descriptor.getDependencyFeatures();
        boolean locked = dependencyFeatures.length > 0;
        for (int i = 0; locked && i < dependencyFeatures.length; ++i) {
            if (registry.getFeatureDescriptor(dependencyFeatures[i]).isUnused()) continue;
            locked = false;
        }
        if (locked) {
            return false;
        }
        for (ApplicabilityFilter filter : filters = registry.getMatchingFilters(featureId)) {
            if (filter.isApplicable(featureId, project)) continue;
            return false;
        }
        long current = System.currentTimeMillis();
        long succesive_interval = (long)descriptor.getDaysBetweenSuccessiveShowUps() * timeUnit + (long)descriptor.getShownCount() * 2L;
        long firstShowUpInterval = (long)descriptor.getDaysBeforeFirstShowUp() * timeUnit;
        long lastTimeUsed = descriptor.getLastTimeUsed();
        long lastTimeShown = descriptor.getLastTimeShown();
        return lastTimeShown == 0L && firstShowUpInterval + this.getFirstRunTime() < current || lastTimeShown > 0L && current - lastTimeShown > succesive_interval && current - lastTimeUsed > succesive_interval;
    }

    public boolean isToBeAdvertisedInLookup(@NonNls String featureId, Project project) {
        FeatureDescriptor descriptor = ProductivityFeaturesRegistry.getInstance().getFeatureDescriptor(featureId);
        if (descriptor != null && System.currentTimeMillis() - descriptor.getLastTimeUsed() > 864000000L) {
            return true;
        }
        return this.isToBeShown(featureId, project, 3600000L);
    }

    @NotNull
    public CompletionStatistics getCompletionStatistics() {
        return this.myCompletionStats;
    }

    public CumulativeStatistics getFixesStats() {
        return this.myFixesStats;
    }

    public long getFirstRunTime() {
        if (this.FIRST_RUN_TIME == 0L) {
            this.FIRST_RUN_TIME = System.currentTimeMillis();
        }
        return this.FIRST_RUN_TIME;
    }

    public void loadState(@NotNull Element element) {
        Element fStats;
        List featuresList = element.getChildren(FEATURE_TAG);
        for (Object aFeaturesList : featuresList) {
            Element featureElement = (Element)aFeaturesList;
            FeatureDescriptor descriptor = this.myRegistry.getFeatureDescriptor(featureElement.getAttributeValue(ATT_ID));
            if (descriptor == null) continue;
            descriptor.readStatistics(featureElement);
        }
        try {
            this.FIRST_RUN_TIME = Long.parseLong(element.getAttributeValue(ATT_FIRST_RUN));
        }
        catch (NumberFormatException e) {
            this.FIRST_RUN_TIME = 0L;
        }
        Element stats = element.getChild(COMPLETION_STATS_TAG);
        if (stats != null) {
            this.myCompletionStats = (CompletionStatistics)XmlSerializer.deserialize((Element)stats, CompletionStatistics.class);
        }
        if ((fStats = element.getChild(FIXES_STATS_TAG)) != null) {
            this.myFixesStats = (CumulativeStatistics)XmlSerializer.deserialize((Element)fStats, CumulativeStatistics.class);
        }
        this.HAVE_BEEN_SHOWN = Boolean.valueOf(element.getAttributeValue(ATT_HAVE_BEEN_SHOWN));
        this.SHOW_IN_OTHER_PROGRESS = Boolean.valueOf(element.getAttributeValue(ATT_SHOW_IN_OTHER, Boolean.toString(true)));
        this.SHOW_IN_COMPILATION_PROGRESS = Boolean.valueOf(element.getAttributeValue(ATT_SHOW_IN_COMPILATION, Boolean.toString(true)));
    }

    public Element getState() {
        Element element = new Element("state");
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        Set ids = registry.getFeatureIds();
        for (String id : ids) {
            Element featureElement = new Element(FEATURE_TAG);
            featureElement.setAttribute(ATT_ID, id);
            FeatureDescriptor descriptor = registry.getFeatureDescriptor(id);
            descriptor.writeStatistics(featureElement);
            element.addContent(featureElement);
        }
        Element statsTag = new Element(COMPLETION_STATS_TAG);
        XmlSerializer.serializeInto((Object)this.myCompletionStats, (Element)statsTag);
        element.addContent(statsTag);
        Element fstatsTag = new Element(FIXES_STATS_TAG);
        XmlSerializer.serializeInto((Object)this.myFixesStats, (Element)fstatsTag);
        element.addContent(fstatsTag);
        element.setAttribute(ATT_FIRST_RUN, String.valueOf(this.getFirstRunTime()));
        element.setAttribute(ATT_HAVE_BEEN_SHOWN, String.valueOf(this.HAVE_BEEN_SHOWN));
        element.setAttribute(ATT_SHOW_IN_OTHER, String.valueOf(this.SHOW_IN_OTHER_PROGRESS));
        element.setAttribute(ATT_SHOW_IN_COMPILATION, String.valueOf(this.SHOW_IN_COMPILATION_PROGRESS));
        return element;
    }

    public void triggerFeatureUsed(String featureId) {
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        FeatureDescriptor descriptor = registry.getFeatureDescriptor(featureId);
        if (descriptor != null) {
            descriptor.triggerUsed();
            Class provider = descriptor.getProvider();
            String id = provider == null || StatisticsUtilKt.getPluginType(provider).isDevelopedByJetBrains() ? descriptor.getId() : "third.party";
            FUCounterUsageLogger.getInstance().logEvent("productivity", id);
        }
    }

    public void triggerFeatureShown(String featureId) {
        FeatureDescriptor descriptor = ProductivityFeaturesRegistry.getInstance().getFeatureDescriptor(featureId);
        if (descriptor != null) {
            descriptor.triggerShown();
        }
    }
}

