/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.actions;

import com.intellij.CommonBundle;
import com.intellij.featureStatistics.CompletionStatistics;
import com.intellij.featureStatistics.CumulativeStatistics;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.util.TipUIUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.table.TableView;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class ShowFeatureUsageStatisticsDialog
extends DialogWrapper {
    private static final Comparator<FeatureDescriptor> DISPLAY_NAME_COMPARATOR = Comparator.comparing(FeatureDescriptor::getDisplayName);
    private static final Comparator<FeatureDescriptor> GROUP_NAME_COMPARATOR = Comparator.comparing(ShowFeatureUsageStatisticsDialog::getGroupName);
    private static final Comparator<FeatureDescriptor> USAGE_COUNT_COMPARATOR = Comparator.comparingInt(FeatureDescriptor::getUsageCount);
    private static final Comparator<FeatureDescriptor> LAST_USED_COMPARATOR = (fd1, fd2) -> new Date(fd2.getLastTimeUsed()).compareTo(new Date(fd1.getLastTimeUsed()));
    private static final ColumnInfo<FeatureDescriptor, String> DISPLAY_NAME = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.feature", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            return featureDescriptor.getDisplayName();
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return DISPLAY_NAME_COMPARATOR;
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> GROUP_NAME = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.group", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            return ShowFeatureUsageStatisticsDialog.getGroupName(featureDescriptor);
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return GROUP_NAME_COMPARATOR;
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> USED_TOTAL = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.usage.count", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            int count = featureDescriptor.getUsageCount();
            return FeatureStatisticsBundle.message((String)"feature.statistics.usage.count", (Object[])new Object[]{count});
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return USAGE_COUNT_COMPARATOR;
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> LAST_USED = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.last.used", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            long tm = featureDescriptor.getLastTimeUsed();
            if (tm <= 0L) {
                return FeatureStatisticsBundle.message((String)"feature.statistics.not.applicable", (Object[])new Object[0]);
            }
            return DateFormatUtil.formatBetweenDates((long)tm, (long)System.currentTimeMillis());
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return LAST_USED_COMPARATOR;
        }
    };
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{DISPLAY_NAME, GROUP_NAME, USED_TOTAL, LAST_USED};

    public ShowFeatureUsageStatisticsDialog(Project project) {
        super(project, true);
        this.setTitle(FeatureStatisticsBundle.message((String)"feature.statistics.dialog.title", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.setModal(false);
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.featureStatistics.actions.ShowFeatureUsageStatisticsDialog";
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getCancelAction(), this.getHelpAction()};
    }

    protected String getHelpId() {
        return "editing.productivityGuide";
    }

    protected JComponent createCenterPanel() {
        Splitter splitter = new Splitter(true);
        splitter.setShowDividerControls(true);
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        ArrayList<FeatureDescriptor> features = new ArrayList<FeatureDescriptor>();
        for (String id : registry.getFeatureIds()) {
            features.add(registry.getFeatureDescriptor(id));
        }
        final TableView table = new TableView(new ListTableModel(COLUMNS, features, 0));
        new TableViewSpeedSearch<FeatureDescriptor>(table){

            @Override
            protected String getItemText(@NotNull FeatureDescriptor element) {
                return element.getDisplayName();
            }
        };
        JPanel controlsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        Application app = ApplicationManager.getApplication();
        long uptime = System.currentTimeMillis() - app.getStartTime();
        long idleTime = app.getIdleTime();
        String uptimeS = FeatureStatisticsBundle.message((String)"feature.statistics.application.uptime", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), DateFormatUtil.formatDuration((long)uptime)});
        String idleTimeS = FeatureStatisticsBundle.message((String)"feature.statistics.application.idle.time", (Object[])new Object[]{DateFormatUtil.formatDuration((long)idleTime)});
        String labelText = uptimeS + ", " + idleTimeS;
        CompletionStatistics stats = ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getCompletionStatistics();
        if (stats.dayCount > 0 && stats.sparedCharacters > 0) {
            String total = ShowFeatureUsageStatisticsDialog.formatCharacterCount(stats.sparedCharacters, true);
            String perDay = ShowFeatureUsageStatisticsDialog.formatCharacterCount(stats.sparedCharacters / stats.dayCount, false);
            labelText = labelText + "<br>Code completion has saved you from typing at least " + total + " since " + DateFormatUtil.formatDate((long)stats.startDate) + " (~" + perDay + " per working day)";
        }
        CumulativeStatistics fstats = ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFixesStats();
        if (fstats.dayCount > 0 && fstats.invocations > 0) {
            labelText = labelText + "<br>Quick fixes have saved you from " + fstats.invocations + " possible bugs since " + DateFormatUtil.formatDate((long)fstats.startDate) + " (~" + fstats.invocations / fstats.dayCount + " per working day)";
        }
        controlsPanel.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)labelText)), "North");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)controlsPanel, "North");
        topPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)table), "Center");
        splitter.setFirstComponent((JComponent)topPanel);
        final TipUIUtil.Browser browser2 = TipUIUtil.createBrowser();
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)browser2.getComponent()));
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Collection selection = table.getSelection();
                if (selection.isEmpty()) {
                    browser2.setText("");
                } else {
                    FeatureDescriptor feature = (FeatureDescriptor)selection.iterator().next();
                    TipUIUtil.openTipInBrowser(TipUIUtil.getTip(feature.getTipFileName()), browser2);
                }
            }
        });
        return splitter;
    }

    private static String formatCharacterCount(int count, boolean full) {
        String result2;
        DecimalFormat oneDigit = new DecimalFormat("0.0");
        String string = count > 0x100000 ? oneDigit.format((double)count / 1024.0 / 1024.0) + "M" : (result2 = count > 1024 ? oneDigit.format((double)count / 1024.0) + "K" : String.valueOf(count));
        if (full) {
            return result2 + " characters";
        }
        return result2;
    }

    private static String getGroupName(FeatureDescriptor featureDescriptor) {
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        GroupDescriptor groupDescriptor = registry.getGroupDescriptor(featureDescriptor.getGroupId());
        return groupDescriptor != null ? groupDescriptor.getDisplayName() : "";
    }
}

