/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.idea.Main;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LicensingFacade;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EAPUsageCollector
extends ApplicationUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        return EAPUsageCollector.collectUsages();
    }

    @NotNull
    private static Set<UsageDescriptor> collectUsages() {
        try {
            if (!Main.isHeadless()) {
                HashSet<UsageDescriptor> result2 = new HashSet<UsageDescriptor>();
                if (ApplicationInfoEx.getInstanceEx().isEAP()) {
                    result2.add(new UsageDescriptor("eap", 1));
                } else {
                    result2.add(new UsageDescriptor("release", 1));
                }
                LicensingFacade facade = LicensingFacade.getInstance();
                if (facade != null) {
                    if (facade.isEvaluationLicense()) {
                        result2.add(new UsageDescriptor("evaluation", 1));
                    } else if (!StringUtil.isEmpty((String)facade.getLicensedToMessage())) {
                        result2.add(new UsageDescriptor("license", 1));
                    }
                }
                return result2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    @Override
    @NotNull
    public String getGroupId() {
        return "user.advanced.info";
    }
}

