/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindAllAction
extends AnAction
implements ShortcutProvider,
DumbAware {
    public FindAllAction() {
        this.getTemplatePresentation().setDescription("Export matches to Find tool window");
        this.getTemplatePresentation().setText("Find All");
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        EditorSearchSession search2 = (EditorSearchSession)e.getData(EditorSearchSession.SESSION_KEY);
        this.updateTemplateIcon(search2);
        e.getPresentation().setIcon(this.getTemplatePresentation().getIcon());
        e.getPresentation().setEnabled(editor != null && project != null && search2 != null && !project.isDisposed() && search2.hasMatches() && PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        EditorSearchSession search2 = (EditorSearchSession)e.getRequiredData(EditorSearchSession.SESSION_KEY);
        if (project.isDisposed()) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return;
        }
        FindModel oldModel = FindManager.getInstance((Project)project).getFindInFileModel();
        FindModel newModel = oldModel.clone();
        String text = search2.getTextInField();
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        newModel.setStringToFind(text);
        FindUtil.findAllAndShow(project, file2, newModel);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        AnAction findUsages = ActionManager.getInstance().getAction("FindUsages");
        return findUsages != null ? findUsages.getShortcutSet() : null;
    }

    private void updateTemplateIcon(@Nullable EditorSearchSession session2) {
        if (session2 == null || this.getTemplatePresentation().getIcon() != null) {
            return;
        }
        Icon base = AllIcons.Actions.Find;
        Icon text = IconUtil.textToIcon((String)"ALL", (Component)session2.getComponent(), (float)JBUI.scale((float)6.0f));
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(base, 0);
        icon.setIcon(text, 1, 0, base.getIconHeight() - text.getIconHeight());
        this.getTemplatePresentation().setIcon((Icon)icon);
    }
}

