/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class FindInPathAction
extends AnAction
implements DumbAware {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Find in Path", (String)ToolWindowId.FIND, (boolean)false);

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        FindInProjectManager findManager = FindInProjectManager.getInstance(project);
        if (!findManager.isEnabled()) {
            FindInPathAction.showNotAvailableMessage(e, project);
            return;
        }
        findManager.findInProject(dataContext, null);
    }

    static void showNotAvailableMessage(AnActionEvent e, Project project) {
        String message = "'" + e.getPresentation().getText() + "' is not available while search is in progress";
        NOTIFICATION_GROUP.createNotification(message, NotificationType.WARNING).notify(project);
    }

    public void update(@NotNull AnActionEvent e) {
        FindInPathAction.doUpdate(e);
    }

    static void doUpdate(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        presentation.setEnabled(project != null);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setVisible(FindInPathAction.isValidSearchScope(e));
        }
    }

    private static boolean isValidSearchScope(@NotNull AnActionEvent e) {
        PsiElement[] elements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY);
        if (elements != null && elements.length == 1 && elements[0] instanceof PsiDirectoryContainer) {
            return true;
        }
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        return virtualFiles != null && virtualFiles.length == 1 && virtualFiles[0].isDirectory();
    }
}

