/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FindUsagesAction
extends AnAction {
    public FindUsagesAction() {
        this.setInjectedContext(true);
    }

    public boolean startInTransaction() {
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UsageTarget[] usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY);
        if (usageTargets == null) {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            FindUsagesAction.chooseAmbiguousTargetAndPerform(project, editor, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element -> {
                this.startFindUsages(element);
                return false;
            }));
        } else {
            UsageTarget target2 = usageTargets[0];
            if (target2 instanceof PsiElementUsageTarget) {
                PsiElement element2 = ((PsiElementUsageTarget)target2).getElement();
                if (element2 != null) {
                    this.startFindUsages(element2);
                }
            } else {
                target2.findUsages();
            }
        }
    }

    protected void startFindUsages(@NotNull PsiElement element) {
        FindManager.getInstance((Project)element.getProject()).findUsages(element);
    }

    public void update(@NotNull AnActionEvent event) {
        FindUsagesInFileAction.updateFindUsagesAction(event);
    }

    static void chooseAmbiguousTargetAndPerform(@NotNull Project project, Editor editor, @NotNull PsiElementProcessor<? super PsiElement> processor2) {
        if (editor == null) {
            Messages.showMessageDialog((Project)project, (String)FindBundle.message("find.no.usages.at.cursor.error", new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        } else {
            int offset = editor.getCaretModel().getOffset();
            boolean chosen = GotoDeclarationAction.chooseAmbiguousTarget(editor, offset, processor2, FindBundle.message("find.usages.ambiguous.title", new Object[0]), null);
            if (!chosen) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (editor.isDisposed() || !editor.getComponent().isShowing()) {
                        return;
                    }
                    HintManager.getInstance().showErrorHint(editor, FindBundle.message("find.no.usages.at.cursor.error", new Object[0]));
                }, project.getDisposed());
            }
        }
    }

    public static class ShowSettingsAndFindUsages
    extends FindUsagesAction {
        @Override
        protected void startFindUsages(@NotNull PsiElement element) {
            FindManager.getInstance((Project)element.getProject()).findUsages(element, true);
        }
    }
}

