/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageToPsiElementProvider;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.UsageAdapter;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShowUsagesTable
extends JBTable
implements DataProvider {
    static final Usage MORE_USAGES_SEPARATOR = NullUsage.INSTANCE;
    static final Usage USAGES_OUTSIDE_SCOPE_SEPARATOR = new UsageAdapter();
    private static final int MARGIN = 2;

    ShowUsagesTable() {
        ScrollingUtil.installActions((JTable)((Object)this));
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            int[] selected = this.getSelectedRows();
            if (selected.length == 1) {
                return ShowUsagesTable.getPsiElementForHint(this.getValueAt(selected[0], 0));
            }
        } else if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
            return PopupUtil.getPopupContainerFor((Component)((Object)this));
        }
        return null;
    }

    public int getRowHeight() {
        return super.getRowHeight() + 4;
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer2, int row2, int column) {
        Component component = super.prepareRenderer(renderer2, row2, column);
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder((Border)JBUI.Borders.empty((int)2, (int)2, (int)2, (int)0));
        }
        return component;
    }

    @NotNull
    Runnable prepareTable(Editor editor, @NotNull RelativePoint popupPosition, @NotNull FindUsagesHandler handler2, int maxUsages, @NotNull FindUsagesOptions options, boolean previewMode, @NotNull ShowUsagesAction action) {
        MySpeedSearch speedSearch = new MySpeedSearch(this);
        speedSearch.setComparator(new SpeedSearchComparator(false));
        this.setRowHeight(PlatformIcons.CLASS_ICON.getIconHeight() + 2);
        this.setShowGrid(false);
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setTableHeader(null);
        this.setAutoResizeMode(3);
        this.setIntercellSpacing(new Dimension(0, 0));
        AtomicReference selectedUsages = new AtomicReference();
        AtomicBoolean moreUsagesSelected = new AtomicBoolean();
        AtomicBoolean outsideScopeUsagesSelected = new AtomicBoolean();
        this.getSelectionModel().addListSelectionListener(e -> {
            selectedUsages.set(null);
            outsideScopeUsagesSelected.set(false);
            moreUsagesSelected.set(false);
            ArrayList<Usage> usages = null;
            for (int i : this.getSelectedRows()) {
                Object value = this.getValueAt(i, 0);
                if (!(value instanceof UsageNode)) continue;
                Usage usage = ((UsageNode)value).getUsage();
                if (usage == USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                    outsideScopeUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usage == MORE_USAGES_SEPARATOR) {
                    moreUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usages == null) {
                    usages = new ArrayList<Usage>();
                }
                usages.add((Usage)(usage instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)usage).getUsageInfo().copy() : usage));
            }
            selectedUsages.set(usages);
        });
        final Runnable itemChosenCallback = () -> {
            if (moreUsagesSelected.get()) {
                action.appendMoreUsages(editor, popupPosition, handler2, maxUsages, options);
                return;
            }
            if (outsideScopeUsagesSelected.get()) {
                options.searchScope = GlobalSearchScope.projectScope((Project)handler2.getProject());
                action.showElementUsages(editor, popupPosition, handler2, maxUsages, options);
                return;
            }
            List usages = (List)selectedUsages.get();
            if (usages != null) {
                for (Object usage : usages) {
                    if (usage instanceof UsageInfo) {
                        UsageViewUtil.navigateTo((UsageInfo)usage, true);
                        continue;
                    }
                    if (!(usage instanceof Navigatable)) continue;
                    ((Navigatable)usage).navigate(true);
                }
            }
        };
        if (previewMode) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (UIUtil.isActionClick((MouseEvent)e, (int)502) && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !e.isConsumed()) {
                        itemChosenCallback.run();
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        itemChosenCallback.run();
                    }
                }
            });
        }
        return itemChosenCallback;
    }

    @Nullable
    private static PsiElement getPsiElementForHint(Object selectedValue) {
        PsiElement element;
        Usage usage;
        if (selectedValue instanceof UsageNode && (usage = ((UsageNode)selectedValue).getUsage()) instanceof UsageInfo2UsageAdapter && (element = ((UsageInfo2UsageAdapter)usage).getElement()) != null) {
            PsiElement view = UsageToPsiElementProvider.findAppropriateParentFrom((PsiElement)element);
            return view == null ? element : view;
        }
        return null;
    }

    private static int calcColumnCount(@NotNull List<UsageNode> data) {
        return data.isEmpty() || data.get(0) instanceof ShowUsagesAction.StringNode ? 1 : 4;
    }

    @NotNull
    MyModel setTableModel(@NotNull UsageViewImpl usageView, @NotNull List<UsageNode> data, @NotNull AtomicInteger outOfScopeUsages, @NotNull SearchScope searchScope) {
        MyModel model;
        ApplicationManager.getApplication().assertIsDispatchThread();
        int columnCount = ShowUsagesTable.calcColumnCount(data);
        MyModel myModel = model = this.getModel() instanceof MyModel ? (MyModel)((Object)this.getModel()) : null;
        if (model == null || model.getColumnCount() != columnCount) {
            model = new MyModel(data, columnCount);
            this.setModel((TableModel)((Object)model));
            ShowUsagesTableCellRenderer renderer2 = new ShowUsagesTableCellRenderer(usageView, outOfScopeUsages, searchScope);
            for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                column.setPreferredWidth(0);
                column.setCellRenderer(renderer2);
            }
        }
        return model;
    }

    static class MyModel
    extends ListTableModel<UsageNode>
    implements ModelDiff.Model<Object> {
        private MyModel(@NotNull List<UsageNode> data, int cols) {
            super(MyModel.cols(cols), data, 0);
        }

        @NotNull
        private static ColumnInfo[] cols(int cols) {
            ColumnInfo<UsageNode, UsageNode> o = new ColumnInfo<UsageNode, UsageNode>(""){

                @Nullable
                public UsageNode valueOf(UsageNode node) {
                    return node;
                }
            };
            List<1> list2 = Collections.nCopies(cols, o);
            return list2.toArray(ColumnInfo.EMPTY_ARRAY);
        }

        @Override
        public void addToModel(int idx, Object element) {
            UsageNode node;
            UsageNode usageNode = node = element instanceof UsageNode ? (UsageNode)element : ShowUsagesAction.createStringNode(element);
            if (idx < this.getRowCount()) {
                this.insertRow(idx, node);
            } else {
                this.addRow(node);
            }
        }

        @Override
        public void removeRangeFromModel(int start2, int end) {
            for (int i = end; i >= start2; --i) {
                this.removeRow(i);
            }
        }
    }

    private static class MySpeedSearch
    extends SpeedSearchBase<JTable> {
        MySpeedSearch(@NotNull ShowUsagesTable table) {
            super(table);
        }

        @Override
        protected int getSelectedIndex() {
            return this.getTable().getSelectedRow();
        }

        @Override
        protected int convertIndexToModel(int viewIndex) {
            return this.getTable().convertRowIndexToModel(viewIndex);
        }

        @Override
        @NotNull
        protected Object[] getAllElements() {
            return ((MyModel)((Object)this.getTable().getModel())).getItems().toArray();
        }

        @Override
        protected String getElementText(@NotNull Object element) {
            if (!(element instanceof UsageNode)) {
                return element.toString();
            }
            UsageNode node = (UsageNode)element;
            if (node instanceof ShowUsagesAction.StringNode) {
                return "";
            }
            Usage usage = node.getUsage();
            if (usage == MORE_USAGES_SEPARATOR || usage == USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                return "";
            }
            GroupNode group = (GroupNode)node.getParent();
            String groupText = group == null ? "" : group.getGroup().getText(null);
            return groupText + usage.getPresentation().getPlainText();
        }

        @Override
        protected void selectElement(Object element, String selectedText) {
            List data = ((MyModel)((Object)this.getTable().getModel())).getItems();
            int i = data.indexOf(element);
            if (i == -1) {
                return;
            }
            int viewRow = this.getTable().convertRowIndexToView(i);
            this.getTable().getSelectionModel().setSelectionInterval(viewRow, viewRow);
            TableUtil.scrollSelectionToVisible((JTable)((Object)this.getTable()));
        }

        private ShowUsagesTable getTable() {
            return (ShowUsagesTable)((Object)this.myComponent);
        }
    }
}

