/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.rules.UsageInFile;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class UsageListCellRenderer
extends ColoredListCellRenderer {
    private final Project myProject;

    public UsageListCellRenderer(@NotNull Project project) {
        this.myProject = project;
    }

    protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
        TextChunk[] text;
        Usage usage = (Usage)value;
        UsagePresentation presentation = usage.getPresentation();
        this.setIcon(presentation.getIcon());
        VirtualFile virtualFile = UsageListCellRenderer.getVirtualFile(usage);
        if (virtualFile != null) {
            this.append(virtualFile.getName() + ": ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.setIcon(virtualFile.getFileType().getIcon());
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
            if (psiFile != null) {
                this.setIcon(psiFile.getIcon(0));
            }
        }
        for (TextChunk textChunk : text = presentation.getText()) {
            SimpleTextAttributes simples = textChunk.getSimpleAttributesIgnoreBackground();
            this.append(textChunk.getText(), simples);
        }
    }

    public static VirtualFile getVirtualFile(Usage usage) {
        return usage instanceof UsageInFile ? ((UsageInFile)usage).getFile() : null;
    }
}

