/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.EditorSearchSession;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OccurrenceAction
extends DumbAwareAction
implements ShortcutProvider {
    protected OccurrenceAction(@NotNull String baseActionId, @NotNull Icon icon) {
        this.copyFrom(ActionManager.getInstance().getAction(baseActionId));
        this.getTemplatePresentation().setIcon(icon);
    }

    public void update(@NotNull AnActionEvent e) {
        EditorSearchSession search2 = (EditorSearchSession)e.getData(EditorSearchSession.SESSION_KEY);
        if (search2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean visible = !search2.getFindModel().isReplaceState() || this.availableForReplace();
        boolean hasMatches = search2.hasMatches();
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && hasMatches);
    }

    protected boolean availableForReplace() {
        return false;
    }

    @Nullable
    public ShortcutSet getShortcut() {
        return this.getShortcutSet();
    }
}

