/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.ContextAwareShortcutProvider;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PrevNextOccurrenceAction
extends DumbAwareAction
implements ContextAwareShortcutProvider {
    protected final boolean mySearch;

    PrevNextOccurrenceAction(@NotNull String templateActionId, boolean search2) {
        this.mySearch = search2;
        this.copyFrom(ActionManager.getInstance().getAction(templateActionId));
    }

    public final void update(@NotNull AnActionEvent e) {
        SearchSession search2 = (SearchSession)e.getData(SearchSession.KEY);
        boolean invokedByShortcut = e.isFromActionToolbar();
        e.getPresentation().setEnabled(search2 != null && (invokedByShortcut || search2.hasMatches()));
    }

    @Override
    @Nullable
    public final ShortcutSet getShortcut(@NotNull DataContext context) {
        SearchSession search2 = (SearchSession)SearchSession.KEY.getData(context);
        boolean singleLine = search2 != null && !search2.getFindModel().isMultiline();
        return Utils.shortcutSetOf(singleLine ? ContainerUtil.concat(this.getDefaultShortcuts(), this.getSingleLineShortcuts()) : this.getDefaultShortcuts());
    }

    @NotNull
    protected abstract List<Shortcut> getDefaultShortcuts();

    @NotNull
    protected abstract List<Shortcut> getSingleLineShortcuts();
}

