/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private Utils() {
    }

    public static void showCompletionPopup(JComponent toolbarComponent, JList list2, String title, JTextComponent textField2, String ad) {
        Runnable callback2 = () -> {
            String selectedValue = (String)list2.getSelectedValue();
            if (selectedValue != null) {
                textField2.setText(selectedValue);
                IdeFocusManager.getGlobalInstance().requestFocus((Component)textField2, false);
            }
        };
        PopupChooserBuilder builder2 = JBPopupFactory.getInstance().createListPopupBuilder(list2);
        if (title != null) {
            builder2.setTitle(title);
        }
        JBPopup popup2 = builder2.setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(callback2).createPopup();
        if (ad != null) {
            popup2.setAdText(ad, 2);
        }
        if (toolbarComponent != null) {
            popup2.showUnderneathOf((Component)toolbarComponent);
        } else {
            popup2.showUnderneathOf((Component)textField2);
        }
    }

    public static void setSmallerFont(JComponent component) {
        if (SystemInfo.isMac) {
            component.setFont((Font)JBUI.Fonts.smallFont());
        }
    }

    public static void setSmallerFontForChildren(JComponent component) {
        for (Component c : component.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            Utils.setSmallerFont((JComponent)c);
        }
    }

    @NotNull
    public static CustomShortcutSet shortcutSetOf(@NotNull List<Shortcut> shortcuts) {
        return new CustomShortcutSet(shortcuts.toArray(Shortcut.EMPTY_ARRAY));
    }

    @NotNull
    public static List<Shortcut> shortcutsOf(@NotNull String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        return action == null ? ContainerUtil.emptyList() : ContainerUtil.immutableList((Object[])action.getShortcutSet().getShortcuts());
    }
}

