/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.ngrams;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.ThreadLocalCachedIntArray;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TrigramIndex
extends ScalarIndexExtension<Integer>
implements CustomInputsIndexFileBasedIndexExtension<Integer> {
    public static final boolean ENABLED = SystemProperties.getBooleanProperty((String)"idea.internal.trigramindex.enabled", (boolean)true);
    public static final ID<Integer, Void> INDEX_ID = ID.create((String)"Trigram.Index");
    private static final FileBasedIndex.InputFilter INPUT_FILTER = file2 -> TrigramIndex.isIndexable(file2.getFileType());
    private static final ThreadLocalCachedIntArray spareBufferLocal = new ThreadLocalCachedIntArray();

    public static boolean isIndexable(FileType fileType) {
        return ENABLED && !fileType.isBinary();
    }

    @NotNull
    public ID<Integer, Void> getName() {
        return INDEX_ID;
    }

    @NotNull
    public DataIndexer<Integer, Void, FileContent> getIndexer() {
        return new DataIndexer<Integer, Void, FileContent>(){

            @NotNull
            public Map<Integer, Void> map(@NotNull FileContent inputData) {
                MyTrigramProcessor trigramProcessor = new MyTrigramProcessor();
                TrigramBuilder.processTrigrams((CharSequence)inputData.getContentAsText(), (TrigramBuilder.TrigramProcessor)trigramProcessor);
                return trigramProcessor.map;
            }
        };
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        return EnumeratorIntegerDescriptor.INSTANCE;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return INPUT_FILTER;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return ENABLED ? 3 + (IdIndex.ourSnapshotMappingsEnabled ? 255 : 0) : 1;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    @Override
    @NotNull
    public DataExternalizer<Collection<Integer>> createExternalizer() {
        return new DataExternalizer<Collection<Integer>>(){

            public void save(@NotNull DataOutput out, @NotNull Collection<Integer> value) throws IOException {
                int numberOfValues = value.size();
                int[] buffer = spareBufferLocal.getBuffer(numberOfValues);
                int ptr = 0;
                for (Integer i : value) {
                    buffer[ptr++] = i;
                }
                Arrays.sort(buffer, 0, numberOfValues);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)numberOfValues);
                int prev2 = 0;
                for (ptr = 0; ptr < numberOfValues; ++ptr) {
                    DataInputOutputUtil.writeLONG((DataOutput)out, (long)((long)buffer[ptr] - (long)prev2));
                    prev2 = buffer[ptr];
                }
            }

            @NotNull
            public Collection<Integer> read(@NotNull DataInput in) throws IOException {
                int size = DataInputOutputUtil.readINT((DataInput)in);
                ArrayList<Integer> result2 = new ArrayList<Integer>(size);
                int prev2 = 0;
                while (size-- > 0) {
                    int l = (int)(DataInputOutputUtil.readLONG((DataInput)in) + (long)prev2);
                    result2.add(l);
                    prev2 = l;
                }
                return result2;
            }
        };
    }

    private static class MyTrigramProcessor
    extends TrigramBuilder.TrigramProcessor {
        Map<Integer, Void> map;

        private MyTrigramProcessor() {
        }

        public boolean consumeTrigramsCount(int count) {
            this.map = new THashMap(count);
            return true;
        }

        public boolean execute(int value) {
            this.map.put(value, null);
            return true;
        }
    }
}

