/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.FormatRangesStorage;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class FormatTextRanges
implements FormattingRangesInfo {
    private final List<TextRange> myInsertedRanges;
    private final FormatRangesStorage myStorage = new FormatRangesStorage();

    public FormatTextRanges() {
        this.myInsertedRanges = null;
    }

    public FormatTextRanges(TextRange range2, boolean processHeadingWhitespace) {
        this.myInsertedRanges = null;
        this.add(range2, processHeadingWhitespace);
    }

    public FormatTextRanges(@NotNull ChangedRangesInfo changedRangesInfo) {
        List<TextRange> optimized = FormatTextRanges.optimizedChangedRanges(changedRangesInfo.allChangedRanges);
        optimized.forEach(range2 -> this.add((TextRange)range2, true));
        this.myInsertedRanges = changedRangesInfo.insertedRanges;
    }

    public void add(TextRange range2, boolean processHeadingWhitespace) {
        this.myStorage.add(range2, processHeadingWhitespace);
    }

    @Override
    public boolean isWhitespaceReadOnly(@NotNull TextRange range2) {
        return this.myStorage.isWhiteSpaceReadOnly(range2);
    }

    @Override
    public boolean isReadOnly(@NotNull TextRange range2) {
        return this.myStorage.isReadOnly(range2);
    }

    @Override
    public boolean isOnInsertedLine(int offset) {
        if (this.myInsertedRanges == null) {
            return false;
        }
        Optional<TextRange> enclosingRange = this.myInsertedRanges.stream().filter(range2 -> range2.contains(offset)).findAny();
        return enclosingRange.isPresent();
    }

    public List<FormatTextRange> getRanges() {
        return this.myStorage.getRanges();
    }

    public FormatTextRanges ensureNonEmpty() {
        FormatTextRanges result2 = new FormatTextRanges();
        for (FormatTextRange range2 : this.myStorage.getRanges()) {
            if (range2.isProcessHeadingWhitespace()) {
                result2.add(range2.getNonEmptyTextRange(), true);
                continue;
            }
            result2.add(range2.getTextRange(), false);
        }
        return result2;
    }

    public boolean isEmpty() {
        return this.myStorage.isEmpty();
    }

    public boolean isFullReformat(PsiFile file2) {
        List<FormatTextRange> ranges = this.myStorage.getRanges();
        return ranges.size() == 1 && file2.getTextRange().equals((Object)ranges.get(0).getTextRange());
    }

    public List<TextRange> getTextRanges() {
        return ContainerUtil.map(this.myStorage.getRanges(), FormatTextRange::getTextRange);
    }

    public List<TextRange> getExtendedFormattingRanges() {
        return ContainerUtil.map(this.myStorage.getRanges(), range2 -> {
            TextRange textRange = range2.getTextRange();
            return new UnfairTextRange(textRange.getStartOffset() - 500, textRange.getEndOffset() + 500);
        });
    }

    private static List<TextRange> optimizedChangedRanges(@NotNull List<TextRange> allChangedRanges) {
        if (allChangedRanges.isEmpty()) {
            return allChangedRanges;
        }
        List sorted = ContainerUtil.sorted(allChangedRanges, (Comparator)Segment.BY_START_OFFSET_THEN_END_OFFSET);
        List result2 = ContainerUtil.newSmartList();
        TextRange prev2 = (TextRange)sorted.get(0);
        for (TextRange next : sorted) {
            if (next.getStartOffset() <= prev2.getEndOffset() + 5) {
                int newEndOffset = Math.max(prev2.getEndOffset(), next.getEndOffset());
                prev2 = new TextRange(prev2.getStartOffset(), newEndOffset);
                continue;
            }
            result2.add(prev2);
            prev2 = next;
        }
        result2.add(prev2);
        return result2;
    }
}

