/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public class FormatterIterationMonitor<T> {
    private static final Logger LOG = Logger.getInstance(FormatterIterationMonitor.class);
    private int myIterations;
    private final int myMaxIterations;
    private final T myFallbackValue;

    public FormatterIterationMonitor(int maxIterations, @NotNull T fallbackValue) {
        this.myMaxIterations = maxIterations;
        this.myFallbackValue = fallbackValue;
    }

    public boolean iterate() {
        int newValue = this.myIterations + 1;
        if (this.myIterations >= this.myMaxIterations) {
            LOG.debug("Iterations limit " + this.myMaxIterations + " reached: ", new Throwable());
            return false;
        }
        this.myIterations = newValue;
        return true;
    }

    @NotNull
    public T getFallbackValue() {
        return this.myFallbackValue;
    }
}

