/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class FileSetProcessor {
    private static final Logger LOG = Logger.getInstance(FileSetProcessor.class);
    private final Set<File> myTopEntries = ContainerUtil.newHashSet();
    private final Set<String> myFileMasks = ContainerUtil.newHashSet();
    private int myProcessedFiles;
    private boolean isRecursive;

    public void processFiles() throws IOException {
        for (File topEntry : this.myTopEntries) {
            this.processEntry(topEntry);
        }
    }

    public void setRecursive() {
        this.isRecursive = true;
    }

    public void addFileMask(@NotNull String fileMask) {
        String fileMaskRegexp = FileSetProcessor.fileMaskToRegexp(fileMask);
        LOG.info("File mask regexp: " + fileMaskRegexp);
        this.myFileMasks.add(fileMaskRegexp);
    }

    private static String fileMaskToRegexp(@NotNull String fileMask) {
        return fileMask.replace(".", "\\.").replace("*", ".*").replace("?", ".").replace("+", "\\+");
    }

    public void addEntry(@NotNull String filePath) throws IOException {
        File file2 = new File(filePath);
        if (!file2.exists()) {
            throw new IOException("File " + filePath + " not found.");
        }
        this.myTopEntries.add(file2);
    }

    private void processEntry(@NotNull File entry) throws IOException {
        if (entry.exists()) {
            if (entry.isDirectory()) {
                LOG.info("Scanning directory " + entry.getPath());
                File[] subEntries = entry.listFiles();
                if (subEntries != null) {
                    for (File subEntry : subEntries) {
                        if (subEntry.isDirectory() && !this.isRecursive) continue;
                        this.processEntry(subEntry);
                    }
                }
            } else if (this.matchesFileMask(entry.getName())) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(entry);
                if (virtualFile == null) {
                    throw new IOException("Can not find " + entry.getPath());
                }
                LOG.info("Processing " + virtualFile.getPath());
                if (this.processFile(virtualFile)) {
                    ++this.myProcessedFiles;
                }
            }
        }
    }

    private boolean matchesFileMask(@NotNull String name) {
        if (this.myFileMasks.isEmpty()) {
            return true;
        }
        for (String fileMask : this.myFileMasks) {
            if (!name.matches(fileMask)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean processFile(@NotNull VirtualFile var1);

    public int getProcessedFiles() {
        return this.myProcessedFiles;
    }
}

