/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.contextConfiguration;

import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.OptionTreeWithPreviewPanel;
import com.intellij.application.options.codeStyle.WrappingAndBracesPanel;
import com.intellij.formatting.contextConfiguration.SelectedTextFormatter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCodeFragmentFilter;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CodeFragmentCodeStyleSettingsPanel
extends TabbedLanguageCodeStylePanel {
    private static final Logger LOG = Logger.getInstance(CodeFragmentCodeStyleSettingsPanel.class);
    private final CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow mySettingsToShow;
    @NotNull
    private final LanguageCodeStyleSettingsProvider mySettingsProvider;
    private final SelectedTextFormatter mySelectedTextFormatter;
    private SpacesPanelWithoutPreview mySpacesPanel;
    private WrappingAndBracesPanelWithoutPreview myWrappingPanel;
    private Runnable mySomethingChangedCallback;

    CodeFragmentCodeStyleSettingsPanel(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow settingsToShow, @NotNull LanguageCodeStyleSettingsProvider settingsProvider, @NotNull SelectedTextFormatter selectedTextFormatter) {
        super(settingsProvider.getLanguage(), settings, settings.clone());
        this.mySettingsToShow = settingsToShow;
        this.mySettingsProvider = settingsProvider;
        this.mySelectedTextFormatter = selectedTextFormatter;
        this.ensureTabs();
    }

    public void setOnSomethingChangedCallback(Runnable runnable2) {
        this.mySomethingChangedCallback = runnable2;
    }

    @Override
    protected void somethingChanged() {
        if (this.mySomethingChangedCallback != null) {
            this.mySomethingChangedCallback.run();
        }
    }

    @Override
    protected String getPreviewText() {
        return null;
    }

    @Override
    protected void updatePreview(boolean useDefaultSample) {
    }

    @Override
    protected void initTabs(CodeStyleSettings settings) {
        SpacesPanelWithoutPreview panel2 = this.getSpacesPanel(settings);
        if (panel2 != null) {
            this.mySpacesPanel = panel2;
            this.addTab(this.mySpacesPanel);
        }
        this.myWrappingPanel = new WrappingAndBracesPanelWithoutPreview(settings);
        this.addTab(this.myWrappingPanel);
        this.reset(this.getSettings());
    }

    @Nullable
    private SpacesPanelWithoutPreview getSpacesPanel(CodeStyleSettings settings) {
        SpacesPanelWithoutPreview spacesPanel = new SpacesPanelWithoutPreview(settings);
        if (spacesPanel.hasSomethingToShow()) {
            return spacesPanel;
        }
        Disposer.dispose((Disposable)spacesPanel);
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySpacesPanel != null ? this.mySpacesPanel.getPreferredFocusedComponent() : this.myWrappingPanel.getPreferredFocusedComponent();
    }

    public static boolean hasOptionsToShow(LanguageCodeStyleSettingsProvider provider) {
        LanguageCodeStyleSettingsProvider.SettingsType[] types;
        for (LanguageCodeStyleSettingsProvider.SettingsType type : types = new LanguageCodeStyleSettingsProvider.SettingsType[]{LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS, LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS}) {
            if (provider.getSupportedFields(type).isEmpty()) continue;
            return true;
        }
        return !provider.getSupportedFields().isEmpty();
    }

    private void reformatSelectedTextWithNewSettings() {
        try {
            this.apply(this.getSettings());
        }
        catch (ConfigurationException e) {
            LOG.debug("Cannot apply code style settings", (Throwable)e);
        }
        CodeStyleSettings clonedSettings = this.getSettings().clone();
        this.mySelectedTextFormatter.reformatSelectedText(clonedSettings);
    }

    @NotNull
    private static CodeStyleSettingsCustomizable getFilteredSettingsConsumer(final @NotNull Collection<String> names, final @NotNull CodeStyleSettingsCustomizable original) {
        return new CodeStyleSettingsCustomizable(){

            public void showAllStandardOptions() {
                original.showStandardOptions(ArrayUtil.toStringArray((Collection)names));
            }

            public void showStandardOptions(String ... optionNames) {
                String[] toShowOptions = (String[])Arrays.stream(optionNames).filter(names::contains).toArray(String[]::new);
                original.showStandardOptions(toShowOptions);
            }

            public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, @Nullable String groupName, Object ... options) {
                if (names.contains(fieldName)) {
                    original.showCustomOption(settingsClass, fieldName, title, groupName, options);
                }
            }

            public void renameStandardOption(String fieldName, String newTitle) {
                if (names.contains(fieldName)) {
                    original.renameStandardOption(fieldName, newTitle);
                }
            }

            public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nullable String anchorFieldName, Object ... options) {
                if (names.contains(fieldName)) {
                    original.showCustomOption(settingsClass, fieldName, title, groupName, anchor2, anchorFieldName, options);
                }
            }
        };
    }

    private class WrappingAndBracesPanelWithoutPreview
    extends TabbedLanguageCodeStylePanel.MyWrappingAndBracesPanel {
        public JPanel myPanel;

        WrappingAndBracesPanelWithoutPreview(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        protected void init() {
            List<String> settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getSettings(this.getSettingsType());
            if (settingNames.isEmpty()) {
                settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getOtherSetting();
            }
            this.initTables();
            Collection<String> fields = this.populateWithAssociatedFields(settingNames);
            fields.add("KEEP_LINE_BREAKS");
            CodeFragmentCodeStyleSettingsPanel.this.mySettingsProvider.customizeSettings(CodeFragmentCodeStyleSettingsPanel.getFilteredSettingsConsumer(settingNames, this), this.getSettingsType());
            this.myTreeTable = this.createOptionsTree(this.getSettings());
            JBScrollPane scrollPane = new JBScrollPane((Component)this.myTreeTable){

                public Dimension getMinimumSize() {
                    return WrappingAndBracesPanelWithoutPreview.this.myTreeTable.getPreferredSize();
                }
            };
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.add((Component)scrollPane);
            this.isFirstUpdate = false;
        }

        @NotNull
        private Collection<String> populateWithAssociatedFields(Collection<String> settingNames) {
            HashSet commonFields = ContainerUtil.newHashSet();
            for (String fieldName : settingNames) {
                WrappingAndBracesPanel.SettingsGroup settingsGroup = this.getAssociatedSettingsGroup(fieldName);
                if (settingsGroup == null) {
                    commonFields.add(fieldName);
                    continue;
                }
                if (settingsGroup.title == WRAPPING_KEEP) continue;
                commonFields.addAll(settingsGroup.commonCodeStyleSettingFieldNames);
            }
            return commonFields;
        }

        @Override
        public JComponent getPanel() {
            return this.myPanel;
        }

        @Override
        protected void somethingChanged() {
            CodeFragmentCodeStyleSettingsPanel.this.mySelectedTextFormatter.restoreSelectedText();
            CodeFragmentCodeStyleSettingsPanel.this.reformatSelectedTextWithNewSettings();
            CodeFragmentCodeStyleSettingsPanel.this.somethingChanged();
        }

        @Override
        protected String getPreviewText() {
            return null;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myTreeTable;
        }
    }

    private class SpacesPanelWithoutPreview
    extends TabbedLanguageCodeStylePanel.MySpacesPanel {
        private JPanel myPanel;

        SpacesPanelWithoutPreview(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        protected void somethingChanged() {
            CodeFragmentCodeStyleSettingsPanel.this.mySelectedTextFormatter.restoreSelectedText();
            CodeFragmentCodeStyleSettingsPanel.this.reformatSelectedTextWithNewSettings();
            CodeFragmentCodeStyleSettingsPanel.this.somethingChanged();
        }

        @Override
        protected void init() {
            List<String> settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getSettings(this.getSettingsType());
            if (settingNames.isEmpty()) {
                settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getOtherSetting();
            }
            CodeFragmentCodeStyleSettingsPanel.this.mySettingsProvider.customizeSettings(CodeFragmentCodeStyleSettingsPanel.getFilteredSettingsConsumer(settingNames, this), this.getSettingsType());
            this.initTables();
            this.myOptionsTree = this.createOptionsTree();
            this.myOptionsTree.setCellRenderer(new OptionTreeWithPreviewPanel.MyTreeCellRenderer());
            JBScrollPane pane = new JBScrollPane(this.myOptionsTree){

                public Dimension getMinimumSize() {
                    return super.getPreferredSize();
                }
            };
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.add((Component)pane);
            this.isFirstUpdate = false;
        }

        public boolean hasSomethingToShow() {
            return !this.myKeys.isEmpty();
        }

        @Override
        public JComponent getPanel() {
            return this.myPanel;
        }

        @Override
        protected String getPreviewText() {
            return null;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myOptionsTree;
        }
    }
}

