/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelEx;
import com.intellij.formatting.IndentInside;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class FormatProcessorUtils {
    private static int calcShift(@NotNull IndentInside oldIndent, @NotNull IndentInside newIndent, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (oldIndent.equals(newIndent)) {
            return 0;
        }
        return newIndent.getSpacesCount(options) - oldIndent.getSpacesCount(options);
    }

    public static int replaceWhiteSpace(FormattingModel model, @NotNull LeafBlockWrapper block, int shift, CharSequence _newWhiteSpace, CommonCodeStyleSettings.IndentOptions options) {
        WhiteSpace whiteSpace = block.getWhiteSpace();
        TextRange textRange = whiteSpace.getTextRange();
        TextRange wsRange = textRange.shiftRight(shift);
        String newWhiteSpace = _newWhiteSpace.toString();
        TextRange newWhiteSpaceRange = model instanceof FormattingModelEx ? ((FormattingModelEx)model).replaceWhiteSpace(wsRange, block.getNode(), newWhiteSpace) : model.replaceWhiteSpace(wsRange, newWhiteSpace);
        shift += newWhiteSpaceRange.getLength() - textRange.getLength();
        if (block.isLeaf() && whiteSpace.containsLineFeeds() && block.containsLineFeeds()) {
            IndentInside whiteSpaceIndent;
            TextRange currentBlockRange = block.getTextRange().shiftRight(shift);
            IndentInside oldBlockIndent = whiteSpace.getInitialLastLineIndent();
            int shiftInside = FormatProcessorUtils.calcShift(oldBlockIndent, whiteSpaceIndent = IndentInside.createIndentOn(IndentInside.getLastLine(newWhiteSpace)), options);
            if (shiftInside != 0 || !oldBlockIndent.equals(whiteSpaceIndent)) {
                TextRange newBlockRange = model.shiftIndentInsideRange(block.getNode(), currentBlockRange, shiftInside);
                shift += newBlockRange.getLength() - block.getLength();
            }
        }
        return shift;
    }
}

