/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.engine.AlignmentHelper;
import com.intellij.formatting.engine.BlockIndentOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentAdjuster {
    private final AlignmentHelper myAlignmentHelper;
    private final BlockIndentOptions myBlockIndentOptions;

    public IndentAdjuster(BlockIndentOptions blockIndentOptions, AlignmentHelper alignmentHelper) {
        this.myAlignmentHelper = alignmentHelper;
        this.myBlockIndentOptions = blockIndentOptions;
    }

    public LeafBlockWrapper adjustIndent(LeafBlockWrapper block) {
        AlignmentImpl alignment = CoreFormatterUtil.getAlignment(block);
        WhiteSpace whiteSpace = block.getWhiteSpace();
        if (alignment == null || this.myAlignmentHelper.shouldSkip(alignment)) {
            if (whiteSpace.containsLineFeeds()) {
                this.adjustSpacingByIndentOffset(block);
            } else {
                whiteSpace.arrangeSpaces(block.getSpaceProperty());
            }
            return null;
        }
        return this.myAlignmentHelper.applyAlignment(alignment, block);
    }

    private void adjustSpacingByIndentOffset(LeafBlockWrapper block) {
        CommonCodeStyleSettings.IndentOptions options = this.myBlockIndentOptions.getIndentOptions(block);
        IndentData offset = block.calculateOffset(options);
        block.getWhiteSpace().setSpaces(offset.getSpaces(), offset.getIndentSpaces());
    }

    public void adjustLineIndent(LeafBlockWrapper myCurrentBlock) {
        IndentData alignOffset = IndentAdjuster.getAlignOffset(myCurrentBlock);
        if (alignOffset == null) {
            this.adjustSpacingByIndentOffset(myCurrentBlock);
        } else {
            myCurrentBlock.getWhiteSpace().setSpaces(alignOffset.getSpaces(), alignOffset.getIndentSpaces());
        }
    }

    @Nullable
    private static IndentData getAlignOffset(LeafBlockWrapper myCurrentBlock) {
        AbstractBlockWrapper current = myCurrentBlock;
        do {
            LeafBlockWrapper offsetResponsibleBlock;
            AlignmentImpl alignment;
            if ((alignment = current.getAlignment()) == null || (offsetResponsibleBlock = alignment.getOffsetRespBlockBefore(myCurrentBlock)) == null) continue;
            WhiteSpace whiteSpace = offsetResponsibleBlock.getWhiteSpace();
            if (whiteSpace.containsLineFeeds()) {
                return new IndentData(whiteSpace.getIndentSpaces(), whiteSpace.getSpaces());
            }
            int offsetBeforeBlock = CoreFormatterUtil.getStartColumn(offsetResponsibleBlock);
            AbstractBlockWrapper indentedParentBlock = CoreFormatterUtil.getIndentedParentBlock(myCurrentBlock);
            if (indentedParentBlock == null) {
                return new IndentData(0, offsetBeforeBlock);
            }
            int parentIndent = indentedParentBlock.getWhiteSpace().getIndentOffset();
            if (parentIndent > offsetBeforeBlock) {
                return new IndentData(0, offsetBeforeBlock);
            }
            return new IndentData(parentIndent, offsetBeforeBlock - parentIndent);
        } while ((current = current.getParent()) != null && current.getStartOffset() == myCurrentBlock.getStartOffset());
        return null;
    }

    public IndentInfo adjustLineIndent(FormatProcessor.ChildAttributesInfo info) {
        AbstractBlockWrapper parent = info.parent;
        ChildAttributes childAttributes = info.attributes;
        int index = info.index;
        AlignWhiteSpace alignWhiteSpace = IndentAdjuster.getAlignOffsetBefore(childAttributes.getAlignment());
        if (alignWhiteSpace == null) {
            return parent.calculateChildOffset(this.myBlockIndentOptions.getIndentOptions(parent), childAttributes, index).createIndentInfo();
        }
        return new IndentInfo(0, alignWhiteSpace.indentSpaces, alignWhiteSpace.alignSpaces);
    }

    private static AlignWhiteSpace getAlignOffsetBefore(@Nullable Alignment alignment) {
        if (alignment == null) {
            return null;
        }
        LeafBlockWrapper alignRespBlock = ((AlignmentImpl)alignment).getOffsetRespBlockBefore(null);
        return alignRespBlock != null ? IndentAdjuster.getStartColumn(alignRespBlock) : null;
    }

    private static AlignWhiteSpace getStartColumn(@NotNull LeafBlockWrapper block) {
        AlignWhiteSpace alignWhitespace = new AlignWhiteSpace();
        do {
            WhiteSpace whiteSpace = block.getWhiteSpace();
            alignWhitespace.alignSpaces += whiteSpace.getSpaces();
            if (whiteSpace.containsLineFeeds()) {
                alignWhitespace.indentSpaces += whiteSpace.getIndentSpaces();
                return alignWhitespace;
            }
            alignWhitespace.alignSpaces += whiteSpace.getIndentSpaces();
            block = block.getPreviousBlock();
            if (alignWhitespace.alignSpaces > 1000 || block == null) {
                return alignWhitespace;
            }
            alignWhitespace.alignSpaces += block.getSymbolsAtTheLastLine();
        } while (!block.containsLineFeeds());
        return alignWhitespace;
    }

    private static class AlignWhiteSpace {
        int indentSpaces = 0;
        int alignSpaces = 0;

        private AlignWhiteSpace() {
        }
    }
}

