/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.templateLanguages;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.templateLanguages.BlockUtil;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLanguageBlock
extends AbstractBlock
implements BlockWithParent {
    private final TemplateLanguageBlockFactory myBlockFactory;
    private final CodeStyleSettings mySettings;
    private List<DataLanguageBlockWrapper> myForeignChildren;
    private boolean myChildrenBuilt = false;
    private BlockWithParent myParent;

    protected TemplateLanguageBlock(@NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings settings, @NotNull ASTNode node, @Nullable List<DataLanguageBlockWrapper> foreignChildren) {
        this(node, null, null, blockFactory, settings, foreignChildren);
    }

    protected TemplateLanguageBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, @NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings settings, @Nullable List<DataLanguageBlockWrapper> foreignChildren) {
        super(node, wrap, alignment);
        this.myBlockFactory = blockFactory;
        this.myForeignChildren = foreignChildren;
        this.mySettings = settings;
    }

    @Override
    protected List<Block> buildChildren() {
        this.myChildrenBuilt = true;
        if (this.isLeaf()) {
            return EMPTY;
        }
        ArrayList<Block> tlChildren = new ArrayList<Block>(5);
        for (ASTNode childNode = this.getNode().getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            if (FormatterUtil.containsWhiteSpacesOnly(childNode) || !this.shouldBuildBlockFor(childNode)) continue;
            TemplateLanguageBlock childBlock = this.myBlockFactory.createTemplateLanguageBlock(childNode, this.createChildWrap(childNode), this.createChildAlignment(childNode), null, this.mySettings);
            childBlock.setParent(this);
            tlChildren.add((Block)childBlock);
        }
        ArrayList<Block> children2 = this.myForeignChildren == null ? tlChildren : BlockUtil.mergeBlocks(tlChildren, this.myForeignChildren);
        return BlockUtil.setParent(children2, this);
    }

    protected boolean shouldBuildBlockFor(ASTNode childNode) {
        return childNode.getElementType() != this.getTemplateTextElementType() || this.noForeignChildren();
    }

    private boolean noForeignChildren() {
        return this.myForeignChildren == null || this.myForeignChildren.isEmpty();
    }

    void addForeignChild(@NotNull DataLanguageBlockWrapper foreignChild) {
        this.initForeignChildren();
        this.myForeignChildren.add(foreignChild);
    }

    void addForeignChildren(List<DataLanguageBlockWrapper> foreignChildren) {
        this.initForeignChildren();
        this.myForeignChildren.addAll(foreignChildren);
    }

    private void initForeignChildren() {
        assert (!this.myChildrenBuilt);
        if (this.myForeignChildren == null) {
            this.myForeignChildren = new ArrayList<DataLanguageBlockWrapper>(5);
        }
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child1 instanceof DataLanguageBlockWrapper && child2 instanceof DataLanguageBlockWrapper) {
            return ((DataLanguageBlockWrapper)child1).getRightHandSpacing((DataLanguageBlockWrapper)child2);
        }
        return null;
    }

    @Nullable
    public Spacing getRightNeighborSpacing(@NotNull Block rightNeighbor, @NotNull DataLanguageBlockWrapper parent, int thisBlockIndex) {
        return null;
    }

    @Nullable
    public Spacing getLeftNeighborSpacing(@Nullable Block leftNeighbor, @NotNull DataLanguageBlockWrapper parent, int thisBlockIndex) {
        return null;
    }

    public boolean isLeaf() {
        return this.noForeignChildren() && this.getNode().getFirstChildNode() == null;
    }

    protected abstract IElementType getTemplateTextElementType();

    @Override
    public BlockWithParent getParent() {
        return this.myParent;
    }

    @Override
    public void setParent(BlockWithParent newParent) {
        this.myParent = newParent;
    }

    public boolean isRequiredRange(TextRange range2) {
        return true;
    }

    protected Wrap createChildWrap(ASTNode child2) {
        return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
    }

    protected Alignment createChildAlignment(ASTNode child2) {
        return null;
    }

    public CodeStyleSettings getSettings() {
        return this.mySettings;
    }

    public List<DataLanguageBlockWrapper> getForeignChildren() {
        return this.myForeignChildren;
    }

    @Nullable
    public Wrap substituteTemplateChildWrap(@NotNull DataLanguageBlockWrapper child2, @Nullable Wrap childWrap) {
        return childWrap;
    }
}

