/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.PathKt;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FrameworkDetectorRegistryImpl
extends FrameworkDetectorRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.framework.detection.impl.FrameworkDetectorRegistryImpl");
    private static final int REGISTRY_VERSION = 0;
    private TObjectIntHashMap<String> myDetectorIds;
    private TIntObjectHashMap<FrameworkDetector> myDetectorById;
    private MultiMap<FileType, Integer> myDetectorsByFileType;
    private int myDetectorsVersion;

    public FrameworkDetectorRegistryImpl() {
        this.loadDetectors();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.saveDetectors();
        }
    }

    private void loadDetectors() {
        HashMap<String, FrameworkDetector> newDetectors = new HashMap<String, FrameworkDetector>();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            newDetectors.put(detector.getDetectorId(), detector);
        }
        this.myDetectorIds = new TObjectIntHashMap();
        Path file2 = FrameworkDetectorRegistryImpl.getDetectorsRegistryFile();
        int maxId = 0;
        if (Files.exists(file2, new LinkOption[0])) {
            LOG.debug("loading framework detectors registry from " + file2.toAbsolutePath());
            ArrayList<String> unknownIds = new ArrayList<String>();
            boolean versionChanged = false;
            try (DataInputStream input = new DataInputStream(new BufferedInputStream(Files.newInputStream(file2, new OpenOption[0])));){
                input.readInt();
                this.myDetectorsVersion = input.readInt();
                int size = input.readInt();
                while (size-- > 0) {
                    String stringId = input.readUTF();
                    int intId = input.readInt();
                    maxId = Math.max(maxId, intId);
                    int version2 = input.readInt();
                    FrameworkDetector detector = (FrameworkDetector)newDetectors.remove(stringId);
                    if (detector != null) {
                        if (version2 != detector.getDetectorVersion()) {
                            LOG.info("Version of framework detector '" + stringId + "' changed: " + version2 + " -> " + detector.getDetectorVersion());
                            versionChanged = true;
                        }
                        this.myDetectorIds.put((Object)stringId, intId);
                        continue;
                    }
                    unknownIds.add(stringId);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            if (!unknownIds.isEmpty()) {
                LOG.debug("Unknown framework detectors: " + unknownIds);
            }
            if (versionChanged || !newDetectors.isEmpty()) {
                if (!newDetectors.isEmpty()) {
                    LOG.info("New framework detectors: " + newDetectors.keySet());
                }
                ++this.myDetectorsVersion;
                LOG.info("Framework detection index version changed to " + this.myDetectorsVersion);
            }
        }
        int nextId = maxId + 1;
        for (String newDetector : newDetectors.keySet()) {
            this.myDetectorIds.put((Object)newDetector, nextId++);
        }
        this.myDetectorById = new TIntObjectHashMap();
        this.myDetectorsByFileType = new MultiMap();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            int id = this.myDetectorIds.get((Object)detector.getDetectorId());
            this.myDetectorsByFileType.putValue((Object)detector.getFileType(), (Object)id);
            this.myDetectorById.put(id, (Object)detector);
            LOG.debug("'" + detector.getDetectorId() + "' framework detector: id = " + id);
        }
    }

    private void saveDetectors() {
        Path file2 = FrameworkDetectorRegistryImpl.getDetectorsRegistryFile();
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(PathKt.outputStream((Path)file2)));){
            output.writeInt(0);
            output.writeInt(this.myDetectorsVersion);
            FrameworkDetector[] detectors = (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions();
            output.writeInt(detectors.length);
            for (FrameworkDetector detector : detectors) {
                output.writeUTF(detector.getDetectorId());
                output.writeInt(this.myDetectorIds.get((Object)detector.getDetectorId()));
                output.writeInt(detector.getDetectorVersion());
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static Path getDetectorsRegistryFile() {
        return FrameworkDetectorRegistryImpl.getDetectionDirPath().resolve("detectors-registry.dat");
    }

    @NotNull
    public static Path getDetectionDirPath() {
        return PathManagerEx.getAppSystemDir().resolve("frameworks").resolve("detection");
    }

    @Override
    public FrameworkType findFrameworkType(@NotNull String typeId) {
        for (FrameworkType frameworkType : this.getFrameworkTypes()) {
            if (!typeId.equals(frameworkType.getId())) continue;
            return frameworkType;
        }
        return null;
    }

    @Override
    @NotNull
    public List<? extends FrameworkType> getFrameworkTypes() {
        ArrayList<FrameworkType> types = new ArrayList<FrameworkType>();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            types.add(detector.getFrameworkType());
        }
        return types;
    }

    @Override
    public int getDetectorsVersion() {
        return this.myDetectorsVersion;
    }

    @Override
    public int getDetectorId(@NotNull FrameworkDetector detector) {
        return this.myDetectorIds.get((Object)detector.getDetectorId());
    }

    @Override
    public FrameworkDetector getDetectorById(int id) {
        return (FrameworkDetector)this.myDetectorById.get(id);
    }

    @Override
    @NotNull
    public Collection<Integer> getDetectorIds(@NotNull FileType fileType) {
        return this.myDetectorsByFileType.get((Object)fileType);
    }

    @Override
    public Collection<Integer> getAllDetectorIds() {
        int[] ids = this.myDetectorIds.getValues();
        ArrayList<Integer> result2 = new ArrayList<Integer>();
        for (int id : ids) {
            result2.add(id);
        }
        return result2;
    }
}

