/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.impl.exclude.ExcludedFileState;
import com.intellij.framework.detection.impl.exclude.ExcludesConfigurationState;
import com.intellij.framework.detection.impl.exclude.old.OldFacetDetectionExcludesConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FrameworkDetectionExcludesConfiguration")
public class DetectionExcludesConfigurationImpl
extends DetectionExcludesConfiguration
implements PersistentStateComponent<ExcludesConfigurationState>,
Disposable {
    private final Map<String, VirtualFilePointerContainer> myExcludedFiles;
    private final Set<String> myExcludedFrameworks;
    private final Project myProject;
    private final VirtualFilePointerManager myPointerManager;
    private boolean myDetectionEnabled = true;
    private boolean myConverted;

    public DetectionExcludesConfigurationImpl(Project project, VirtualFilePointerManager pointerManager) {
        this.myProject = project;
        this.myPointerManager = pointerManager;
        this.myExcludedFrameworks = new HashSet<String>();
        this.myExcludedFiles = FactoryMap.create(key -> this.myPointerManager.createContainer((Disposable)this));
    }

    public void addExcludedFramework(@NotNull FrameworkType type) {
        this.convert();
        this.myExcludedFrameworks.add(type.getId());
        VirtualFilePointerContainer container = this.myExcludedFiles.remove(type.getId());
        if (container != null) {
            container.clear();
        }
    }

    public void addExcludedFile(@NotNull VirtualFile file2, @Nullable FrameworkType type) {
        String typeId;
        this.convert();
        String string = typeId = type != null ? type.getId() : null;
        if (typeId != null && this.myExcludedFrameworks.contains(typeId) || this.isFileExcluded(file2, typeId)) {
            return;
        }
        VirtualFilePointerContainer container = this.myExcludedFiles.get(typeId);
        if (typeId == null) {
            for (VirtualFilePointerContainer pointerContainer : this.myExcludedFiles.values()) {
                this.removeDescendants(file2, pointerContainer);
            }
        } else {
            this.removeDescendants(file2, container);
        }
        container.add(file2);
    }

    public void addExcludedUrl(@NotNull String url, @Nullable FrameworkType type) {
        String typeId;
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file2 != null) {
            this.addExcludedFile(file2, type);
            return;
        }
        this.convert();
        String string = typeId = type != null ? type.getId() : null;
        if (typeId != null && this.myExcludedFrameworks.contains(typeId)) {
            return;
        }
        this.myExcludedFiles.get(typeId).add(url);
    }

    private void convert() {
        this.ensureOldSettingsLoaded();
        this.markAsConverted();
    }

    private void markAsConverted() {
        this.myConverted = true;
        OldFacetDetectionExcludesConfiguration.getInstance(this.myProject).unsetState();
    }

    private void ensureOldSettingsLoaded() {
        OldFacetDetectionExcludesConfiguration oldConfiguration;
        ExcludesConfigurationState oldState;
        if (!this.myConverted && (oldState = (oldConfiguration = OldFacetDetectionExcludesConfiguration.getInstance(this.myProject)).convert()) != null) {
            this.doLoadState(oldState);
        }
    }

    public boolean isExcludedFromDetection(@NotNull VirtualFile file2, @NotNull FrameworkType frameworkType) {
        this.ensureOldSettingsLoaded();
        return this.isExcludedFromDetection(frameworkType) || this.isFileExcluded(file2, frameworkType.getId());
    }

    public boolean isExcludedFromDetection(@NotNull FrameworkType frameworkType) {
        this.ensureOldSettingsLoaded();
        return !this.myDetectionEnabled || this.myExcludedFrameworks.contains(frameworkType.getId());
    }

    private boolean isFileExcluded(@NotNull VirtualFile file2, @Nullable String typeId) {
        if (this.myExcludedFiles.containsKey(typeId) && DetectionExcludesConfigurationImpl.isUnder(file2, this.myExcludedFiles.get(typeId))) {
            return true;
        }
        return typeId != null && this.myExcludedFiles.containsKey(null) && DetectionExcludesConfigurationImpl.isUnder(file2, this.myExcludedFiles.get(null));
    }

    private static boolean isUnder(VirtualFile file2, VirtualFilePointerContainer container) {
        for (VirtualFile excludedFile : container.getFiles()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)excludedFile, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void removeDescendants(VirtualFile file2, VirtualFilePointerContainer container) {
        for (VirtualFile virtualFile : container.getFiles()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)virtualFile, (boolean)false)) continue;
            container.remove(this.myPointerManager.create(virtualFile, (Disposable)this, null));
        }
    }

    public void removeExcluded(@NotNull Collection<VirtualFile> files2, FrameworkType frameworkType) {
        this.ensureOldSettingsLoaded();
        if (!this.myDetectionEnabled || this.myExcludedFrameworks.contains(frameworkType.getId())) {
            files2.clear();
            return;
        }
        Iterator<VirtualFile> iterator = files2.iterator();
        while (iterator.hasNext()) {
            VirtualFile file2 = iterator.next();
            if (!this.isFileExcluded(file2, frameworkType.getId())) continue;
            iterator.remove();
        }
    }

    @NotNull
    public ExcludesConfigurationState getActualState() {
        this.ensureOldSettingsLoaded();
        ExcludesConfigurationState state = new ExcludesConfigurationState();
        state.setDetectionEnabled(this.myDetectionEnabled);
        state.getFrameworkTypes().addAll(this.myExcludedFrameworks);
        Collections.sort(state.getFrameworkTypes(), String.CASE_INSENSITIVE_ORDER);
        for (String typeId : this.myExcludedFiles.keySet()) {
            VirtualFilePointerContainer container = this.myExcludedFiles.get(typeId);
            for (String url : container.getUrls()) {
                state.getFiles().add(new ExcludedFileState(url, typeId));
            }
        }
        Collections.sort(state.getFiles(), (o1, o2) -> StringUtil.comparePairs((String)o1.getFrameworkType(), (String)o1.getUrl(), (String)o2.getFrameworkType(), (String)o2.getUrl(), (boolean)true));
        return state;
    }

    @Nullable
    public ExcludesConfigurationState getState() {
        if (!this.myConverted) {
            return null;
        }
        return this.getActualState();
    }

    public void loadState(@NotNull ExcludesConfigurationState state) {
        this.doLoadState(state);
        if (!(this.myExcludedFiles.isEmpty() && this.myExcludedFrameworks.isEmpty() && this.myDetectionEnabled)) {
            this.markAsConverted();
        }
    }

    private void doLoadState(@Nullable ExcludesConfigurationState state) {
        this.myExcludedFrameworks.clear();
        for (VirtualFilePointerContainer container : this.myExcludedFiles.values()) {
            container.clear();
        }
        boolean bl = this.myDetectionEnabled = state == null || state.isDetectionEnabled();
        if (state != null) {
            this.myExcludedFrameworks.addAll(state.getFrameworkTypes());
            for (ExcludedFileState fileState : state.getFiles()) {
                this.myExcludedFiles.get(fileState.getFrameworkType()).add(fileState.getUrl());
            }
        }
    }

    public void dispose() {
    }
}

