/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude.old;

import com.intellij.framework.detection.impl.exclude.ExcludedFileState;
import com.intellij.framework.detection.impl.exclude.ExcludesConfigurationState;
import com.intellij.framework.detection.impl.exclude.old.DisabledAutodetectionByTypeElement;
import com.intellij.framework.detection.impl.exclude.old.DisabledAutodetectionInModuleElement;
import com.intellij.framework.detection.impl.exclude.old.DisabledAutodetectionInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FacetAutodetectingManager")
public class OldFacetDetectionExcludesConfiguration
implements PersistentStateComponent<DisabledAutodetectionInfo> {
    public static final String COMPONENT_NAME = "FacetAutodetectingManager";
    private DisabledAutodetectionInfo myDisabledAutodetectionInfo;
    private final Project myProject;

    public static OldFacetDetectionExcludesConfiguration getInstance(Project project) {
        return (OldFacetDetectionExcludesConfiguration)ServiceManager.getService((Project)project, OldFacetDetectionExcludesConfiguration.class);
    }

    public OldFacetDetectionExcludesConfiguration(Project project) {
        this.myProject = project;
    }

    public DisabledAutodetectionInfo getState() {
        return this.myDisabledAutodetectionInfo;
    }

    public void loadState(@NotNull DisabledAutodetectionInfo state) {
        this.myDisabledAutodetectionInfo = state;
    }

    public void unsetState() {
        this.myDisabledAutodetectionInfo = null;
    }

    @Nullable
    public ExcludesConfigurationState convert() {
        if (this.myDisabledAutodetectionInfo == null || this.myDisabledAutodetectionInfo.getElements().isEmpty()) {
            return null;
        }
        ExcludesConfigurationState state = new ExcludesConfigurationState();
        for (DisabledAutodetectionByTypeElement element : this.myDisabledAutodetectionInfo.getElements()) {
            String frameworkId = element.getFacetTypeId();
            List<DisabledAutodetectionInModuleElement> moduleElements = element.getModuleElements();
            if (moduleElements.isEmpty()) {
                state.getFrameworkTypes().add(frameworkId);
                continue;
            }
            LinkedHashSet<String> excludedUrls = new LinkedHashSet<String>();
            for (DisabledAutodetectionInModuleElement moduleElement : moduleElements) {
                if (moduleElement.isDisableInWholeModule()) {
                    Module module = ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleElement.getModuleName());
                    if (module == null) continue;
                    Collections.addAll(excludedUrls, ModuleRootManager.getInstance((Module)module).getContentRootUrls());
                    continue;
                }
                excludedUrls.addAll(moduleElement.getFiles());
                excludedUrls.addAll(moduleElement.getDirectories());
            }
            for (String url : excludedUrls) {
                state.getFiles().add(new ExcludedFileState(url, frameworkId));
            }
        }
        return state;
    }
}

