/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.ui;

import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.impl.ui.DetectedFrameworkTreeNodeBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class DetectedFrameworkNode
extends DetectedFrameworkTreeNodeBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.framework.detection.impl.ui.DetectedFrameworkNode");
    private final DetectedFrameworkDescription myDescription;
    private final FrameworkDetectionContext myContext;

    DetectedFrameworkNode(DetectedFrameworkDescription description, FrameworkDetectionContext context) {
        super(description);
        this.myDescription = description;
        this.myContext = context;
    }

    @Override
    public void renderNode(ColoredTreeCellRenderer renderer2) {
        renderer2.setIcon(this.myDescription.getDetector().getFrameworkType().getIcon());
        Collection files2 = this.myDescription.getRelatedFiles();
        VirtualFile firstFile = (VirtualFile)ContainerUtil.getFirstItem((Collection)files2);
        LOG.assertTrue(firstFile != null);
        if (files2.size() == 1) {
            renderer2.append(firstFile.getName());
            this.appendDirectoryPath(renderer2, firstFile.getParent());
        } else {
            String commonName = firstFile.getName();
            VirtualFile commonParent = firstFile.getParent();
            for (VirtualFile file2 : files2) {
                if (commonName != null && !commonName.equals(file2.getName())) {
                    commonName = null;
                }
                if (commonParent == null || commonParent.equals(file2.getParent())) continue;
                commonParent = null;
            }
            renderer2.append(files2.size() + " " + (commonName != null ? commonName : firstFile.getFileType().getDefaultExtension()) + " files");
            if (commonParent != null) {
                this.appendDirectoryPath(renderer2, commonParent);
            }
        }
    }

    @Override
    public String getCheckedDescription() {
        return this.myDescription.getSetupText();
    }

    @Override
    public String getUncheckedDescription() {
        return null;
    }

    @Override
    public void disableDetection(DetectionExcludesConfiguration configuration2) {
        for (VirtualFile file2 : this.myDescription.getRelatedFiles()) {
            configuration2.addExcludedFile(file2, this.myDescription.getDetector().getFrameworkType());
        }
    }

    private void appendDirectoryPath(ColoredTreeCellRenderer renderer2, VirtualFile dir) {
        String path = this.getRelativePath(dir);
        renderer2.append(" (" + (path.isEmpty() ? "/" : path) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @NotNull
    private String getRelativePath(@NotNull VirtualFile file2) {
        String path;
        VirtualFile dir = this.myContext.getBaseDir();
        if (dir != null && (path = VfsUtilCore.getRelativePath((VirtualFile)dir, (VirtualFile)file2, (char)File.separatorChar)) != null) {
            return path;
        }
        return file2.getPresentableUrl();
    }
}

