/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library.impl;

import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.frameworks.beans.ArtifactItem;
import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.framework.library.DownloadableLibraryDescription;
import com.intellij.framework.library.DownloadableLibraryFileDescription;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.framework.library.impl.DownloadableLibraryFileDescriptionImpl;
import com.intellij.framework.library.impl.FrameworkLibraryVersionImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.download.impl.FileSetVersionsFetcherBase;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryVersionsFetcher
extends FileSetVersionsFetcherBase<FrameworkLibraryVersion, DownloadableLibraryFileDescription>
implements DownloadableLibraryDescription {
    public LibraryVersionsFetcher(@NotNull String groupId, @NotNull URL[] localUrls) {
        super(groupId, localUrls);
    }

    @Override
    protected FrameworkLibraryVersion createVersion(Artifact version2, List<DownloadableLibraryFileDescription> files2) {
        return new FrameworkLibraryVersionImpl(version2.getName(), version2.getVersion(), this.createAvailabilityCondition(version2), files2, this.myGroupId);
    }

    @NotNull
    protected FrameworkAvailabilityCondition createAvailabilityCondition(Artifact version2) {
        return FrameworkAvailabilityCondition.ALWAYS_TRUE;
    }

    @Override
    protected DownloadableLibraryFileDescription createFileDescription(ArtifactItem item, String url, String prefix) {
        String docUrl;
        String sourceUrl = item.getSourceUrl();
        if (sourceUrl != null) {
            sourceUrl = LibraryVersionsFetcher.prependPrefix(sourceUrl, prefix);
        }
        if ((docUrl = item.getDocUrl()) != null) {
            docUrl = LibraryVersionsFetcher.prependPrefix(docUrl, prefix);
        }
        String name = item.getName();
        return new DownloadableLibraryFileDescriptionImpl(url, FileUtil.getNameWithoutExtension((String)name), FileUtilRt.getExtension((String)name), sourceUrl, docUrl, item.isOptional());
    }
}

