/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.ByteContent;
import com.intellij.history.core.ChangeList;
import com.intellij.history.core.Content;
import com.intellij.history.core.LabelImpl;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateDirectoryChange;
import com.intellij.history.core.changes.CreateFileChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.MoveChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.core.changes.ROStatusChange;
import com.intellij.history.core.changes.RenameChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.revisions.ChangeRevision;
import com.intellij.history.core.revisions.RecentChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalHistoryFacade {
    private final ChangeList myChangeList;
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public LocalHistoryFacade(ChangeList changeList) {
        this.myChangeList = changeList;
    }

    public void beginChangeSet() {
        this.myChangeList.beginChangeSet();
    }

    public void forceBeginChangeSet() {
        if (this.myChangeList.forceBeginChangeSet()) {
            this.fireChangeSetFinished();
        }
    }

    public void endChangeSet(String name) {
        if (this.myChangeList.endChangeSet(name)) {
            this.fireChangeSetFinished();
        }
    }

    public void created(String path, boolean isDirectory) {
        this.addChange(isDirectory ? new CreateDirectoryChange(this.myChangeList.nextId(), path) : new CreateFileChange(this.myChangeList.nextId(), path));
    }

    public void contentChanged(String path, Content oldContent, long oldTimestamp) {
        this.addChange(new ContentChange(this.myChangeList.nextId(), path, oldContent, oldTimestamp));
    }

    public void renamed(String path, String oldName) {
        this.addChange(new RenameChange(this.myChangeList.nextId(), path, oldName));
    }

    public void readOnlyStatusChanged(String path, boolean oldStatus) {
        this.addChange(new ROStatusChange(this.myChangeList.nextId(), path, oldStatus));
    }

    public void moved(String path, String oldParent) {
        this.addChange(new MoveChange(this.myChangeList.nextId(), path, oldParent));
    }

    public void deleted(String path, Entry deletedEntry) {
        this.addChange(new DeleteChange(this.myChangeList.nextId(), path, deletedEntry));
    }

    public LabelImpl putSystemLabel(String name, String projectId, int color) {
        return this.putLabel(new PutSystemLabelChange(this.myChangeList.nextId(), name, projectId, color));
    }

    public LabelImpl putUserLabel(String name, String projectId) {
        return this.putLabel(new PutLabelChange(this.myChangeList.nextId(), name, projectId));
    }

    private void addChange(@NotNull Change c) {
        this.beginChangeSet();
        this.myChangeList.addChange(c);
        this.fireChangeAdded(c);
        this.endChangeSet(null);
    }

    public void addChangeInTests(@NotNull StructuralChange c) {
        this.addChange(c);
    }

    private LabelImpl putLabel(final @NotNull PutLabelChange c) {
        this.addChange(c);
        return new LabelImpl(){

            @Override
            public long getLabelChangeId() {
                return c.getId();
            }

            @Override
            public ByteContent getByteContent(RootEntry root, String path) {
                return LocalHistoryFacade.this.getByteContentBefore(root, path, c);
            }
        };
    }

    public void putLabelInTests(PutLabelChange c) {
        this.putLabel(c);
    }

    public ChangeList getChangeListInTests() {
        return this.myChangeList;
    }

    private ByteContent getByteContentBefore(RootEntry root, String path, Change change) {
        String newPath;
        Entry entry = (root = root.copy()).findEntry(newPath = this.revertUpTo(root, path, null, change, false, false));
        if (entry == null) {
            return new ByteContent(false, null);
        }
        if (entry.isDirectory()) {
            return new ByteContent(true, null);
        }
        return new ByteContent(false, entry.getContent().getBytesIfAvailable());
    }

    public List<RecentChange> getRecentChanges(RootEntry root) {
        ArrayList<RecentChange> result2 = new ArrayList<RecentChange>();
        for (ChangeSet c : this.myChangeList.iterChanges()) {
            if (c.isContentChangeOnly() || c.isLabelOnly() || c.getName() == null) continue;
            ChangeRevision before = new ChangeRevision(this, root, "", c, true);
            ChangeRevision after = new ChangeRevision(this, root, "", c, false);
            result2.add(new RecentChange(before, after));
            if (result2.size() < 20) continue;
            break;
        }
        return result2;
    }

    public void accept(ChangeVisitor v) {
        this.myChangeList.accept(v);
    }

    public String revertUpTo(final @NotNull RootEntry root, @NotNull String path, final ChangeSet targetChangeSet, final Change targetChange, final boolean revertTargetChange, final boolean warnOnFileNotFound) {
        final String[] result2 = new String[]{path};
        this.myChangeList.accept(new ChangeVisitor(){

            @Override
            public void begin(ChangeSet c) throws ChangeVisitor.StopVisitingException {
                if (!revertTargetChange && c.equals(targetChangeSet)) {
                    this.stop();
                }
            }

            @Override
            public void end(ChangeSet c) throws ChangeVisitor.StopVisitingException {
                if (c.equals(targetChangeSet)) {
                    this.stop();
                }
            }

            @Override
            public void visit(PutLabelChange c) throws ChangeVisitor.StopVisitingException {
                if (c.equals(targetChange)) {
                    this.stop();
                }
            }

            @Override
            public void visit(StructuralChange c) throws ChangeVisitor.StopVisitingException {
                if (!revertTargetChange && c.equals(targetChange)) {
                    this.stop();
                }
                c.revertOn(root, warnOnFileNotFound);
                result2[0] = c.revertPath(result2[0]);
                if (c.equals(targetChange)) {
                    this.stop();
                }
            }
        });
        return result2[0];
    }

    public void addListener(final @NotNull Listener l, @Nullable Disposable parent) {
        this.myListeners.add(l);
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)new Disposable(){

                public void dispose() {
                    LocalHistoryFacade.this.myListeners.remove(l);
                }
            });
        }
    }

    public void removeListener(@NotNull Listener l) {
        this.myListeners.remove(l);
    }

    private void fireChangeAdded(Change c) {
        for (Listener each : this.myListeners) {
            each.changeAdded(c);
        }
    }

    private void fireChangeSetFinished() {
        for (Listener each : this.myListeners) {
            each.changeSetFinished();
        }
    }

    public static abstract class Listener {
        public void changeAdded(Change c) {
        }

        public void changeSetFinished() {
        }
    }
}

