/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.revisions;

import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Difference {
    private final boolean myIsFile;
    private final Entry myLeft;
    private final Entry myRight;
    private final boolean myRightContentCurrent;

    public Difference(boolean isFile, Entry left, Entry right) {
        this(isFile, left, right, false);
    }

    public Difference(boolean isFile, @Nullable Entry left, @Nullable Entry right, boolean isRightContentCurrent) {
        this.myIsFile = isFile;
        this.myLeft = left;
        this.myRight = right;
        this.myRightContentCurrent = isRightContentCurrent;
    }

    public boolean isFile() {
        return this.myIsFile;
    }

    public Entry getLeft() {
        return this.myLeft;
    }

    public Entry getRight() {
        return this.myRight;
    }

    public ContentRevision getLeftContentRevision(IdeaGateway gw) {
        return Difference.createContentRevision(this.getLeft(), gw);
    }

    public ContentRevision getRightContentRevision(IdeaGateway gw) {
        VirtualFile file2;
        Entry entry = this.getRight();
        if (this.myRightContentCurrent && entry != null && (file2 = gw.findVirtualFile(entry.getPath())) != null) {
            return new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)file2));
        }
        return Difference.createContentRevision(entry, gw);
    }

    private static ContentRevision createContentRevision(final @Nullable Entry e, final IdeaGateway gw) {
        if (e == null) {
            return null;
        }
        return new ByteBackedContentRevision(){

            @Nullable
            public String getContent() throws VcsException {
                if (e.isDirectory()) {
                    return null;
                }
                return e.getContent().getString(e, gw);
            }

            @Nullable
            public byte[] getContentAsBytes() throws VcsException {
                if (e.isDirectory()) {
                    return null;
                }
                return e.getContent().getBytes();
            }

            @NotNull
            public FilePath getFile() {
                return VcsUtil.getFilePath((File)new File(e.getPath()), (boolean)e.isDirectory());
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                return VcsRevisionNumber.NULL;
            }
        };
    }
}

