/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.LabelImpl;
import com.intellij.history.core.revisions.ChangeRevision;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.integration.ui.models.RevisionItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LocalHistoryUtil {
    static int findRevisionIndexToRevert(@NotNull HistoryDialogModel dirHistoryModel, @NotNull LabelImpl label2) {
        List<RevisionItem> revs = dirHistoryModel.getRevisions();
        for (int i = 0; i < revs.size(); ++i) {
            RevisionItem rev = revs.get(i);
            if (LocalHistoryUtil.isLabelRevision(rev, label2)) {
                return i;
            }
            if (!LocalHistoryUtil.isChangeWithId(rev.revision, label2.getLabelChangeId())) continue;
            return i;
        }
        return -1;
    }

    static boolean isLabelRevision(@NotNull RevisionItem rev, @NotNull LabelImpl label2) {
        long targetChangeId = label2.getLabelChangeId();
        return ContainerUtil.exists(rev.labels, revision -> LocalHistoryUtil.isChangeWithId(revision, targetChangeId));
    }

    private static boolean isChangeWithId(@NotNull Revision revision, long targetChangeId) {
        return revision instanceof ChangeRevision && ((ChangeRevision)revision).containsChangeWithId(targetChangeId);
    }
}

