/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.patches;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PatchCreator {
    public static void create(Project p, List<? extends Change> changes2, String filePath, boolean isReverse, CommitContext commitContext) throws IOException, VcsException {
        PatchCreator.create(p, (String)ObjectUtils.assertNotNull((Object)p.getBasePath()), changes2, filePath, isReverse, commitContext, Charset.defaultCharset());
    }

    public static void create(Project p, @NotNull String basePath, List<? extends Change> changes2, String filePath, boolean isReverse, CommitContext commitContext, Charset charset) throws IOException, VcsException {
        List<FilePatch> patches2 = IdeaTextPatchBuilder.buildPatch(p, changes2, basePath, isReverse);
        PatchWriter.writePatches(p, filePath, basePath, patches2, commitContext, charset);
    }
}

