/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.actions;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.UtilKt;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalHistoryAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        Presentation p = e.getPresentation();
        if (e.getProject() == null) {
            p.setEnabledAndVisible(false);
        } else {
            p.setVisible(true);
            p.setText(this.getText(e), true);
            LocalHistoryFacade vcs = this.getVcs();
            IdeaGateway gateway = this.getGateway();
            p.setEnabled(vcs != null && gateway != null && this.isEnabled(vcs, gateway, e));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.actionPerformed((Project)e.getRequiredData(CommonDataKeys.PROJECT), (IdeaGateway)ObjectUtils.notNull((Object)this.getGateway()), e);
    }

    protected String getText(@NotNull AnActionEvent e) {
        return e.getPresentation().getTextWithMnemonic();
    }

    protected boolean isEnabled(@NotNull LocalHistoryFacade vcs, @NotNull IdeaGateway gw, @NotNull AnActionEvent e) {
        return this.isEnabled(vcs, gw, this.getFile(e), e);
    }

    protected void actionPerformed(@NotNull Project p, @NotNull IdeaGateway gw, @NotNull AnActionEvent e) {
        this.actionPerformed(p, gw, (VirtualFile)ObjectUtils.notNull((Object)this.getFile(e)), e);
    }

    protected boolean isEnabled(@NotNull LocalHistoryFacade vcs, @NotNull IdeaGateway gw, @Nullable VirtualFile f, @NotNull AnActionEvent e) {
        return true;
    }

    protected void actionPerformed(@NotNull Project p, @NotNull IdeaGateway gw, @NotNull VirtualFile f, @NotNull AnActionEvent e) {
    }

    @Nullable
    protected LocalHistoryFacade getVcs() {
        return LocalHistoryImpl.getInstanceImpl().getFacade();
    }

    @Nullable
    protected IdeaGateway getGateway() {
        return LocalHistoryImpl.getInstanceImpl().getGateway();
    }

    @Nullable
    protected VirtualFile getFile(@NotNull AnActionEvent e) {
        return (VirtualFile)UtilKt.getIfSingle((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)));
    }
}

