/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.actions;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.actions.ShowHistoryAction;
import com.intellij.history.integration.ui.views.SelectionHistoryDialog;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSelectionHistoryAction
extends ShowHistoryAction {
    @Override
    protected void actionPerformed(@NotNull Project p, @NotNull IdeaGateway gw, @NotNull VirtualFile f, @NotNull AnActionEvent e) {
        VcsSelection sel = (VcsSelection)ObjectUtils.notNull((Object)ShowSelectionHistoryAction.getSelection(e));
        int from = sel.getSelectionStartLineNumber();
        int to = sel.getSelectionEndLineNumber();
        new SelectionHistoryDialog(p, gw, f, from, to).show();
    }

    @Override
    protected String getText(@NotNull AnActionEvent e) {
        VcsSelection sel = ShowSelectionHistoryAction.getSelection(e);
        return sel == null ? super.getText(e) : sel.getActionName();
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (ShowSelectionHistoryAction.getSelection(e) == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            super.update(e);
        }
    }

    @Override
    protected boolean isEnabled(@NotNull LocalHistoryFacade vcs, @NotNull IdeaGateway gw, @Nullable VirtualFile f, @NotNull AnActionEvent e) {
        return super.isEnabled(vcs, gw, f, e) && !((VirtualFile)ObjectUtils.notNull((Object)f)).isDirectory() && ShowSelectionHistoryAction.getSelection(e) != null;
    }

    @Nullable
    private static VcsSelection getSelection(@NotNull AnActionEvent e) {
        return VcsSelectionUtil.getSelection((VcsContext)VcsContextWrapper.createCachedInstanceOn(e));
    }
}

