/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HtmlLineMarkerProvider
implements LineMarkerProvider {
    private final Map<Language, List<LineMarkerProvider>> embeddedLanguagesLineMarkerProviders = ContainerUtil.newConcurrentMap();

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            return null;
        }
        Language language = element.getLanguage();
        if (!(language instanceof XMLLanguage)) {
            List<LineMarkerProvider> markerProviders = HtmlLineMarkerProvider.getAllLineMarkerProvidersForLanguage(language, this.embeddedLanguagesLineMarkerProviders);
            for (LineMarkerProvider provider : markerProviders) {
                LineMarkerInfo info;
                if (provider instanceof HtmlLineMarkerProvider || (info = provider.getLineMarkerInfo(element)) == null) continue;
                return info;
            }
        }
        return null;
    }

    @NotNull
    private static List<LineMarkerProvider> getAllLineMarkerProvidersForLanguage(@NotNull Language language, @NotNull Map<Language, List<LineMarkerProvider>> embeddedLanguagesLineMarkerProviders) {
        List markerProviders = embeddedLanguagesLineMarkerProviders.get(language);
        if (markerProviders == null) {
            markerProviders = LineMarkerProviders.INSTANCE.allForLanguage(language);
            embeddedLanguagesLineMarkerProviders.put(language, markerProviders);
        }
        return markerProviders;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        THashMap localEmbeddedLanguagesLineMarkerProviders = null;
        Map embeddedLineMarkersWorkItems = null;
        for (PsiElement psiElement : elements) {
            Language language;
            if (psiElement instanceof PsiWhiteSpace || (language = psiElement.getLanguage()) instanceof XMLLanguage) continue;
            if (localEmbeddedLanguagesLineMarkerProviders == null) {
                localEmbeddedLanguagesLineMarkerProviders = new THashMap();
            }
            List<LineMarkerProvider> lineMarkerProviders = HtmlLineMarkerProvider.getAllLineMarkerProvidersForLanguage(language, localEmbeddedLanguagesLineMarkerProviders);
            for (LineMarkerProvider provider : lineMarkerProviders) {
                if (provider instanceof HtmlLineMarkerProvider) continue;
                if (embeddedLineMarkersWorkItems == null) {
                    embeddedLineMarkersWorkItems = new THashMap();
                }
                List elementList = embeddedLineMarkersWorkItems.computeIfAbsent(provider, k -> new ArrayList(5));
                elementList.add(psiElement);
            }
        }
        if (embeddedLineMarkersWorkItems != null) {
            for (Map.Entry entry : embeddedLineMarkersWorkItems.entrySet()) {
                ((LineMarkerProvider)entry.getKey()).collectSlowLineMarkers((List)entry.getValue(), result2);
            }
        }
    }
}

