/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ClipboardSynchronizer;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.CaretStateTransferableData;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ide.CutElementMarker;
import com.intellij.openapi.ide.KillRingTransferable;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.EventDispatcher;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyPasteManagerEx
extends CopyPasteManager
implements ClipboardOwner {
    private final List<Transferable> myData = new ArrayList<Transferable>();
    private final EventDispatcher<CopyPasteManager.ContentChangedListener> myDispatcher = EventDispatcher.create(CopyPasteManager.ContentChangedListener.class);
    private final ClipboardSynchronizer myClipboardSynchronizer;
    private boolean myOwnContent;

    public static CopyPasteManagerEx getInstanceEx() {
        return (CopyPasteManagerEx)CopyPasteManagerEx.getInstance();
    }

    public CopyPasteManagerEx(ClipboardSynchronizer clipboardSynchronizer) {
        this.myClipboardSynchronizer = clipboardSynchronizer;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.myOwnContent = false;
        this.myClipboardSynchronizer.resetContent();
        this.fireContentChanged(contents, null);
    }

    private void fireContentChanged(@Nullable Transferable oldContent, @Nullable Transferable newContent) {
        ((CopyPasteManager.ContentChangedListener)this.myDispatcher.getMulticaster()).contentChanged(oldContent, newContent);
    }

    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2, @NotNull Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeContentChangedListener(@NotNull CopyPasteManager.ContentChangedListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
        return flavors.length > 0 && this.myClipboardSynchronizer.areDataFlavorsAvailable(flavors);
    }

    public void setContents(@NotNull Transferable content) {
        Transferable oldContent = this.myOwnContent && !this.myData.isEmpty() ? this.myData.get(0) : null;
        Transferable contentToUse = this.addNewContentToStack(content);
        this.setSystemClipboardContent(contentToUse);
        this.fireContentChanged(oldContent, contentToUse);
    }

    public boolean isCutElement(@Nullable Object element) {
        for (CutElementMarker marker : CutElementMarker.EP_NAME.getExtensionList()) {
            if (!marker.isCutElement(element)) continue;
            return true;
        }
        return false;
    }

    public void stopKillRings() {
        for (Transferable data : this.myData) {
            if (!(data instanceof KillRingTransferable)) continue;
            ((KillRingTransferable)data).setReadyToCombine(false);
        }
    }

    private void setSystemClipboardContent(Transferable content) {
        this.myClipboardSynchronizer.setContent(content, this);
        this.myOwnContent = true;
    }

    @NotNull
    private Transferable addNewContentToStack(@NotNull Transferable content) {
        try {
            String clipString = CopyPasteManagerEx.getStringContent(content);
            if (clipString == null) {
                return content;
            }
            if (content instanceof KillRingTransferable) {
                Transferable merged;
                Transferable prev2;
                KillRingTransferable killRingContent = (KillRingTransferable)content;
                if (killRingContent.isReadyToCombine() && !this.myData.isEmpty() && (prev2 = this.myData.get(0)) instanceof KillRingTransferable && (merged = CopyPasteManagerEx.merge(killRingContent, (KillRingTransferable)prev2)) != null) {
                    this.myData.set(0, merged);
                    return merged;
                }
                if (killRingContent.isReadyToCombine()) {
                    this.addToTheTopOfTheStack((Transferable)killRingContent);
                    return killRingContent;
                }
            }
            CaretStateTransferableData caretData = CaretStateTransferableData.getFrom(content);
            for (int i = 0; i < this.myData.size(); ++i) {
                Transferable old = this.myData.get(i);
                if (!clipString.equals(CopyPasteManagerEx.getStringContent(old)) || !CaretStateTransferableData.areEquivalent(caretData, CaretStateTransferableData.getFrom(old))) continue;
                this.myData.remove(i);
                this.myData.add(0, content);
                return content;
            }
            this.addToTheTopOfTheStack(content);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        return content;
    }

    private void addToTheTopOfTheStack(@NotNull Transferable content) {
        this.myData.add(0, content);
        this.deleteAfterAllowedMaximum();
    }

    @Nullable
    private static Transferable merge(@NotNull KillRingTransferable newData, @NotNull KillRingTransferable oldData) throws IOException, UnsupportedFlavorException {
        if (!oldData.isReadyToCombine() || !newData.isReadyToCombine()) {
            return null;
        }
        Document document = newData.getDocument();
        if (document == null || document != oldData.getDocument()) {
            return null;
        }
        Object newDataText = newData.getTransferData(DataFlavor.stringFlavor);
        Object oldDataText = oldData.getTransferData(DataFlavor.stringFlavor);
        if (newDataText == null || oldDataText == null) {
            return null;
        }
        if (oldData.isCut() && newData.getStartOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(oldDataText.toString() + newDataText, document, oldData.getStartOffset(), newData.getEndOffset(), newData.isCut());
        }
        if (newData.getStartOffset() == oldData.getEndOffset()) {
            return new KillRingTransferable(oldDataText.toString() + newDataText, document, oldData.getStartOffset(), newData.getEndOffset(), false);
        }
        if (newData.getEndOffset() == oldData.getStartOffset()) {
            return new KillRingTransferable(newDataText.toString() + oldDataText, document, newData.getStartOffset(), oldData.getEndOffset(), false);
        }
        return null;
    }

    private static String getStringContent(Transferable content) {
        try {
            return (String)content.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return null;
        }
    }

    private void deleteAfterAllowedMaximum() {
        int max = UISettings.getInstance().getMaxClipboardContents();
        for (int i = this.myData.size() - 1; i >= max; --i) {
            this.myData.remove(i);
        }
    }

    public Transferable getContents() {
        return this.myClipboardSynchronizer.getContents();
    }

    @Nullable
    public <T> T getContents(@NotNull DataFlavor flavor) {
        if (this.areDataFlavorsAvailable(flavor)) {
            return (T)this.myClipboardSynchronizer.getData(flavor);
        }
        return null;
    }

    @NotNull
    public Transferable[] getAllContents() {
        String clipString = (String)this.getContents(DataFlavor.stringFlavor);
        if (clipString != null && (this.myData.isEmpty() || !Comparing.equal((String)clipString, (String)CopyPasteManagerEx.getStringContent(this.myData.get(0))))) {
            this.addToTheTopOfTheStack(new StringSelection(clipString));
        }
        return this.myData.toArray(new Transferable[0]);
    }

    public void removeContent(Transferable t) {
        Transferable current = this.myData.isEmpty() ? null : this.myData.get(0);
        this.myData.remove(t);
        if (Comparing.equal((Object)t, (Object)current)) {
            Transferable newContent = !this.myData.isEmpty() ? this.myData.get(0) : new StringSelection("");
            this.setSystemClipboardContent(newContent);
            this.fireContentChanged(current, newContent);
        }
    }

    public void moveContentToStackTop(Transferable t) {
        Transferable current;
        Transferable transferable = current = this.myData.isEmpty() ? null : this.myData.get(0);
        if (!Comparing.equal((Object)t, (Object)current)) {
            this.myData.remove(t);
            this.myData.add(0, t);
            this.setSystemClipboardContent(t);
            this.fireContentChanged(current, t);
        } else {
            this.setSystemClipboardContent(t);
        }
    }
}

