/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.psi.PsiElement;
import java.awt.datatransfer.Transferable;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class CopyPasteUtil {
    private CopyPasteUtil() {
    }

    public static PsiElement[] getElementsInTransferable(Transferable t) {
        PsiElement[] elts = PsiCopyPasteManager.getElements(t);
        return elts != null ? elts : PsiElement.EMPTY_ARRAY;
    }

    public static void addDefaultListener(@NotNull Disposable parent, @NotNull Consumer<? super PsiElement> consumer) {
        CopyPasteManager.getInstance().addContentChangedListener((CopyPasteManager.ContentChangedListener)new DefaultCopyPasteListener(consumer), parent);
    }

    public static class DefaultCopyPasteListener
    implements CopyPasteManager.ContentChangedListener {
        private final Consumer<? super PsiElement> consumer;

        @Deprecated
        public DefaultCopyPasteListener(AbstractTreeUpdater updater) {
            this((? super PsiElement element) -> updater.addSubtreeToUpdateByElement(element));
        }

        private DefaultCopyPasteListener(@NotNull Consumer<? super PsiElement> consumer) {
            this.consumer = consumer;
        }

        public void contentChanged(Transferable oldTransferable, Transferable newTransferable) {
            Application application = ApplicationManager.getApplication();
            if (application == null || application.isReadAccessAllowed()) {
                this.updateByTransferable(oldTransferable);
                this.updateByTransferable(newTransferable);
            } else {
                application.runReadAction(() -> {
                    this.updateByTransferable(oldTransferable);
                    this.updateByTransferable(newTransferable);
                });
            }
        }

        private void updateByTransferable(Transferable t) {
            PsiElement[] psiElements;
            for (PsiElement psiElement : psiElements = CopyPasteUtil.getElementsInTransferable(t)) {
                if (psiElement.getProject().isDisposed()) continue;
                this.consumer.accept((PsiElement)psiElement);
            }
        }
    }
}

