/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileChangedNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(FileChangedNotificationProvider.class);
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"file.changed.notification.panel");

    public FileChangedNotificationProvider(final @NotNull Project project) {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)project);
        connection.subscribe(FrameStateListener.TOPIC, (Object)new FrameStateListener(){

            public void onFrameActivated() {
                if (!project.isDisposed() && !GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    EditorNotifications notifications = EditorNotifications.getInstance((Project)project);
                    for (VirtualFile file2 : FileEditorManager.getInstance((Project)project).getSelectedFiles()) {
                        notifications.updateNotifications(file2);
                    }
                }
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (!project.isDisposed() && !GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    HashSet openFiles = ContainerUtil.newHashSet((Object[])FileEditorManager.getInstance((Project)project).getSelectedFiles());
                    EditorNotifications notifications = EditorNotifications.getInstance((Project)project);
                    for (VFileEvent vFileEvent : events) {
                        VirtualFile file2 = vFileEvent.getFile();
                        if (file2 == null || !openFiles.contains(file2)) continue;
                        notifications.updateNotifications(file2);
                    }
                }
            }
        });
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        FileAttributes attributes;
        VirtualFileSystem fs;
        if (!(project.isDisposed() || GeneralSettings.getInstance().isSyncOnFrameActivation() || !((fs = file2.getFileSystem()) instanceof LocalFileSystem) || (attributes = ((LocalFileSystem)fs).getAttributes(file2)) != null && file2.getTimeStamp() == attributes.lastModified && file2.getLength() == attributes.length)) {
            LogUtil.debug((Logger)LOG, (String)"%s: (%s,%s) -> %s", (Object[])new Object[]{file2, file2.getTimeStamp(), file2.getLength(), attributes});
            return FileChangedNotificationProvider.createPanel(file2, project);
        }
        return null;
    }

    private static EditorNotificationPanel createPanel(@NotNull VirtualFile file2, @NotNull Project project) {
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText(IdeBundle.message((String)"file.changed.externally.message", (Object[])new Object[0]));
        panel2.createActionLabel(IdeBundle.message((String)"file.changed.externally.reload", (Object[])new Object[0]), () -> {
            if (!project.isDisposed()) {
                file2.refresh(false, false);
                EditorNotifications.getInstance((Project)project).updateNotifications(file2);
            }
        });
        return panel2;
    }
}

