/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeView;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.dnd.LinuxDragAndDropSupport;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileListPasteProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        PsiDirectory dir;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || ideView == null) {
            return;
        }
        if (!FileCopyPasteUtil.isFileListFlavorAvailable()) {
            return;
        }
        Transferable contents = CopyPasteManager.getInstance().getContents();
        if (contents == null) {
            return;
        }
        List<File> fileList = FileCopyPasteUtil.getFileList(contents);
        if (fileList == null) {
            return;
        }
        if (DumbService.isDumb((Project)project)) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Sorry, file copy/paste is not available during indexing");
            return;
        }
        ArrayList<PsiFileSystemItem> elements = new ArrayList<PsiFileSystemItem>();
        for (File file2 : fileList) {
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
            PsiFileSystemItem item = PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)vFile);
            if (item == null) continue;
            elements.add(item);
        }
        if (elements.size() > 0 && (dir = ideView.getOrChooseDirectory()) != null) {
            boolean move = LinuxDragAndDropSupport.isMoveOperation(contents);
            if (move) {
                new MoveFilesOrDirectoriesHandler().doMove(PsiUtilCore.toPsiElementArray(elements), (PsiElement)dir);
            } else {
                new CopyFilesOrDirectoriesHandler().doCopy(PsiUtilCore.toPsiElementArray(elements), dir);
            }
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        return LangDataKeys.IDE_VIEW.getData(dataContext) != null && FileCopyPasteUtil.isFileListFlavorAvailable();
    }
}

