/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedFileEditingNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"generated.source.file.editing.notification.panel");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (!GeneratedSourceFileChangeTracker.getInstance(project).isEditedGeneratedFile(file2)) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText("Generated source files should not be edited. The changes will be lost when sources are regenerated.");
        return panel2;
    }
}

