/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.AppTopics;
import com.intellij.ProjectTopics;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class GeneratedSourceFileChangeTrackerImpl
extends GeneratedSourceFileChangeTracker
implements ProjectComponent,
Disposable {
    private final Project myProject;
    private final FileDocumentManager myDocumentManager;
    private final EditorNotifications myEditorNotifications;
    private final SingleAlarm myCheckingQueue;
    private final Set<VirtualFile> myFilesToCheck = Collections.synchronizedSet(new HashSet());
    private final Set<VirtualFile> myEditedGeneratedFiles = Collections.synchronizedSet(new HashSet());
    public static boolean IN_TRACKER_TEST;

    public GeneratedSourceFileChangeTrackerImpl(Project project, FileDocumentManager documentManager, EditorNotifications editorNotifications) {
        this.myProject = project;
        this.myDocumentManager = documentManager;
        this.myEditorNotifications = editorNotifications;
        this.myCheckingQueue = new SingleAlarm(this::checkFiles, 500, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    public void dispose() {
    }

    void waitForAlarm(long timeout, @NotNull TimeUnit timeUnit) throws Exception {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not wait for the alarm under write action");
        }
        this.myCheckingQueue.waitForAllExecuted(timeout, timeUnit);
    }

    public void cancelAllAndWait(long timeout, @NotNull TimeUnit timeUnit) throws Exception {
        this.myFilesToCheck.clear();
        this.myCheckingQueue.cancelAllRequests();
        this.waitForAlarm(timeout, timeUnit);
    }

    @Override
    public boolean isEditedGeneratedFile(@NotNull VirtualFile file2) {
        return this.myEditedGeneratedFiles.contains(file2);
    }

    public void projectOpened() {
        if (ApplicationManager.getApplication().isUnitTestMode() && !IN_TRACKER_TEST) {
            return;
        }
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (GeneratedSourceFileChangeTrackerImpl.this.myProject.isDisposed()) {
                    return;
                }
                VirtualFile file2 = GeneratedSourceFileChangeTrackerImpl.this.myDocumentManager.getFile(e.getDocument());
                ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)GeneratedSourceFileChangeTrackerImpl.this.myProject);
                if (file2 != null && (fileIndex.isInContent(file2) || fileIndex.isInLibrary(file2))) {
                    GeneratedSourceFileChangeTrackerImpl.this.myFilesToCheck.add(file2);
                    GeneratedSourceFileChangeTrackerImpl.this.myCheckingQueue.cancelAndRequest();
                }
            }
        }, (Disposable)this.myProject);
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                GeneratedSourceFileChangeTrackerImpl.this.myFilesToCheck.remove(file2);
                if (GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.remove(file2)) {
                    GeneratedSourceFileChangeTrackerImpl.this.myEditorNotifications.updateNotifications(file2);
                }
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.remove(file2);
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                GeneratedSourceFileChangeTrackerImpl.this.myFilesToCheck.addAll(GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles);
                GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.clear();
                GeneratedSourceFileChangeTrackerImpl.this.myCheckingQueue.cancelAndRequest();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFiles() {
        VirtualFile[] files2;
        Set<VirtualFile> set2 = this.myFilesToCheck;
        synchronized (set2) {
            files2 = this.myFilesToCheck.toArray(VirtualFile.EMPTY_ARRAY);
            this.myFilesToCheck.clear();
        }
        if (files2.length == 0) {
            return;
        }
        ArrayList newEditedGeneratedFiles = new ArrayList();
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (VirtualFile file2 : files2) {
                if (!GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)this.myProject)) continue;
                newEditedGeneratedFiles.add(file2);
            }
        });
        if (!newEditedGeneratedFiles.isEmpty()) {
            this.myEditedGeneratedFiles.addAll(newEditedGeneratedFiles);
            this.myEditorNotifications.updateAllNotifications();
        }
    }
}

