/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import java.io.IOException;

public class IdeAboutInfoUtil {
    public static void writeAboutJson(JsonWriter writer) throws IOException {
        String appName = ApplicationInfoEx.getInstanceEx().getFullApplicationName();
        BuildNumber build2 = ApplicationInfo.getInstance().getBuild();
        if (!PlatformUtils.isIdeaUltimate()) {
            String productName = ApplicationNamesInfo.getInstance().getProductName();
            appName = appName.replace(productName + " (" + productName + ")", productName);
            appName = StringUtil.trimStart((String)appName, (String)"JetBrains ");
        }
        writer.name("name").value(appName);
        writer.name("productName").value(ApplicationNamesInfo.getInstance().getProductName());
        writer.name("baselineVersion").value((long)build2.getBaselineVersion());
        if (!build2.isSnapshot()) {
            writer.name("buildNumber").value(build2.asStringWithoutProductCode());
        }
    }
}

